/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.jdeparser.BasicJBlock;
import org.jboss.jdeparser.FinallyJBlock;
import org.jboss.jdeparser.FirstJVarDeclaration;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.ImplJCatch;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JCatch;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JTry;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;
import org.jboss.jdeparser.TryJVarDeclaration;

class ImplJTry
extends BasicJBlock
implements JTry {
    private ArrayList<ImplJCatch> catches;
    private ArrayList<FirstJVarDeclaration> resources;
    private FinallyJBlock finallyBlock;

    ImplJTry(BasicJBlock parent) {
        super(parent, JBlock.Braces.REQUIRED);
    }

    @Override
    public JVarDeclaration with(int mods, String type, String var, JExpr init) {
        return this.with(mods, JTypes.typeNamed(type), var, init);
    }

    @Override
    public JVarDeclaration with(int mods, JType type, String var, JExpr init) {
        return this.add(new TryJVarDeclaration(mods, type, var, init, this));
    }

    @Override
    public JVarDeclaration with(int mods, Class<? extends AutoCloseable> type, String var, JExpr init) {
        return this.with(mods, JTypes.typeOf(type), var, init);
    }

    private <T extends FirstJVarDeclaration> T add(T item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        this.resources.add(item);
        return item;
    }

    @Override
    public JCatch _catch(int mods, String type, String var) {
        return this._catch(mods, JTypes.typeNamed(type), var);
    }

    @Override
    public JCatch _catch(int mods, Class<? extends Throwable> type, String var) {
        return this._catch(mods, JTypes.typeOf(type), var);
    }

    @Override
    public JCatch _catch(int mods, JType type, String var) {
        return this.add(new ImplJCatch(this, mods, type, var));
    }

    private <T extends ImplJCatch> T add(T item) {
        if (this.catches == null) {
            this.catches = new ArrayList();
        }
        this.catches.add(item);
        return item;
    }

    @Override
    public JTry ignore(String type) {
        return this.ignore(JTypes.typeNamed(type));
    }

    @Override
    public JTry ignore(Class<? extends Throwable> type) {
        return this.ignore(JTypes.typeOf(type));
    }

    @Override
    public JTry ignore(JType type) {
        this._catch(0, type, "ignored");
        return this;
    }

    @Override
    public JBlock _finally() {
        if (this.finallyBlock == null) {
            this.finallyBlock = new FinallyJBlock(this);
        }
        return this.finallyBlock;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        this.writeComments(writer);
        if ((this.catches == null || this.catches.isEmpty()) && (this.resources == null || this.resources.isEmpty()) && this.finallyBlock == null) {
            super.write(writer, null);
        } else {
            writer.write(Tokens$.KW.TRY);
            if (this.resources != null) {
                Iterator<FirstJVarDeclaration> iterator = this.resources.iterator();
                if (iterator.hasNext()) {
                    writer.write(FormatPreferences.Space.BEFORE_PAREN_TRY);
                    writer.write(Tokens$.PUNCT.PAREN.OPEN);
                    writer.write(FormatPreferences.Space.WITHIN_PAREN_TRY);
                    iterator.next().writeNoSemi(writer);
                    while (iterator.hasNext()) {
                        writer.write(FormatPreferences.Space.BEFORE_SEMICOLON);
                        writer.write(Tokens$.PUNCT.SEMI);
                        writer.write(FormatPreferences.Space.AFTER_SEMICOLON);
                        iterator.next().writeNoSemi(writer);
                    }
                }
                writer.write(FormatPreferences.Space.WITHIN_PAREN_TRY);
                writer.write(Tokens$.PUNCT.PAREN.CLOSE);
            }
            super.write(writer, FormatPreferences.Space.BEFORE_BRACE_TRY);
            if (this.catches != null) {
                for (ImplJCatch _catch : this.catches) {
                    _catch.write(writer);
                }
            }
            if (this.finallyBlock != null) {
                this.finallyBlock.write(writer);
            }
        }
    }
}

