/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.authorization;

import jakarta.ejb.EJBContext;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.glassfish.soteria.authorization.EJB;

public class JACC {
    public static String SUBJECT_CONTAINER_KEY = "javax.security.auth.Subject.container";

    public static Subject getSubject() {
        return (Subject)JACC.getFromContext(SUBJECT_CONTAINER_KEY);
    }

    public static boolean isCallerInRole(String role) {
        Subject subject = JACC.getSubject();
        if (JACC.hasPermission(subject, (Permission)new WebRoleRefPermission("", role))) {
            return true;
        }
        EJBContext ejbContext = EJB.getEJBContext();
        if (ejbContext != null) {
            String ejbName = EJB.getCurrentEJBName(ejbContext);
            if (ejbName != null) {
                return JACC.hasPermission(subject, (Permission)new EJBRoleRefPermission(ejbName, role));
            }
            return ejbContext.isCallerInRole(role);
        }
        return false;
    }

    public static boolean hasAccessToWebResource(String resource, String ... methods) {
        return JACC.hasPermission(JACC.getSubject(), (Permission)new WebResourcePermission(resource, methods));
    }

    public static Set<String> getAllDeclaredCallerRoles() {
        PermissionCollection permissionCollection = JACC.getPermissionCollection(JACC.getSubject());
        permissionCollection.implies((Permission)new WebRoleRefPermission("", "nothing"));
        permissionCollection.implies((Permission)new EJBRoleRefPermission("", "nothing"));
        return JACC.filterRoles(permissionCollection);
    }

    public static boolean hasPermission(Subject subject, Permission permission) {
        return JACC.getPolicyPrivileged().implies(JACC.fromSubject(subject), permission);
    }

    public static PermissionCollection getPermissionCollection(Subject subject) {
        return JACC.getPolicyPrivileged().getPermissions(JACC.fromSubject(subject));
    }

    private static Policy getPolicyPrivileged() {
        return AccessController.doPrivileged(new PrivilegedAction<Policy>(){

            @Override
            public Policy run() {
                return Policy.getPolicy();
            }
        });
    }

    public static Set<String> filterRoles(PermissionCollection permissionCollection) {
        HashSet<String> roles = new HashSet<String>();
        for (Permission permission : Collections.list(permissionCollection.elements())) {
            String role;
            if (!JACC.isRolePermission(permission) || roles.contains(role = permission.getActions()) || !JACC.isCallerInRole(role)) continue;
            roles.add(role);
        }
        return roles;
    }

    public static ProtectionDomain fromSubject(Subject subject) {
        Principal[] principals = subject != null ? subject.getPrincipals().toArray(new Principal[subject.getPrincipals().size()]) : new Principal[]{};
        return new ProtectionDomain(new CodeSource(null, (Certificate[])null), null, null, principals);
    }

    public static <T> T getFromContext(final String contextName) {
        try {
            Object ctx = AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws PolicyContextException {
                    return PolicyContext.getContext((String)contextName);
                }
            });
            return ctx;
        }
        catch (PrivilegedActionException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    public static boolean isRolePermission(Permission permission) {
        return permission instanceof WebRoleRefPermission || permission instanceof EJBRoleRefPermission;
    }
}

