/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator.util.reflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

final class ParameterizedTypeImpl
implements ParameterizedType {
    private final Class<?> genericClass;
    private final Type[] typeArguments;
    private final Type ownerType;

    ParameterizedTypeImpl(Class<?> genericClass, Type ... typeArguments) {
        this(genericClass, typeArguments, (Type)null);
    }

    ParameterizedTypeImpl(Class<?> genericClass, Type[] typeArguments, Type ownerType) {
        this.genericClass = genericClass;
        this.typeArguments = typeArguments;
        this.ownerType = ownerType;
    }

    @Override
    public Type getRawType() {
        return this.genericClass;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ParameterizedType) {
            ParameterizedType that = (ParameterizedType)o;
            return Objects.equals(this.ownerType, that.getOwnerType()) && Objects.equals(this.genericClass, that.getRawType()) && Arrays.equals(this.typeArguments, that.getActualTypeArguments());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.typeArguments) ^ Objects.hashCode(this.ownerType) ^ Objects.hashCode(this.genericClass);
    }

    public String toString() {
        StringJoiner result = new StringJoiner(",", this.genericClass.getName() + "<", ">");
        result.setEmptyValue(this.genericClass.getName());
        for (Type typeArgument : this.typeArguments) {
            result.add(typeArgument.toString());
        }
        return result.toString();
    }
}

