/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.appclient.server.core.jws.CombinedXPath;
import org.glassfish.appclient.server.core.jws.XPathToDeveloperProvidedContentRefs;
import org.glassfish.logging.annotation.LogMessageInfo;

class ClientJNLPConfigData {
    private static final String CONFIG_FILE_NAME = "client-jnlp-config.properties";
    private File previousConfigFileUsed = null;
    private File configFileFromDomain;
    private File configFileFromInstall;
    private long lastModified = -1L;
    private static Logger logger = Logger.getLogger("jakarta.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages");
    @LogMessageInfo(message="Config file for client JNLP not found: {0}", cause="The config file does not exist.", action="The file is part of the installation so this might be an internal error.  Make sure you have not accidentally removed or renamed the config file.  If not, please file an error with a reproducible test case.")
    public static final String NO_CONFIG_FILE = "AS-ACDEPL-00108";
    @LogMessageInfo(message="The config file for client JNLP {0} exists but could not be read.", cause="The config file might be protected from reading.", action="Make sure the config file protection settings permit the server to read it.")
    public static final String CONFIG_UNREADABLE = "AS-ACDEPL-00109";
    private List<XPathToDeveloperProvidedContentRefs> xPathsToDevContentRefs = Collections.EMPTY_LIST;
    private List<CombinedXPath> xPathsToCombinedContent = Collections.EMPTY_LIST;

    ClientJNLPConfigData(File installConfigDir, File domainConfigDir) {
        this.configFileFromInstall = new File(installConfigDir, CONFIG_FILE_NAME);
        this.configFileFromDomain = new File(domainConfigDir, CONFIG_FILE_NAME);
        this.ensureCurrent();
    }

    private void ensureCurrent() {
        File configFile = this.chooseConfigFile();
        if (configFile == null) {
            this.lastModified = -1L;
            this.xPathsToDevContentRefs = Collections.EMPTY_LIST;
            this.xPathsToCombinedContent = Collections.EMPTY_LIST;
            return;
        }
        if (this.lastModified < configFile.lastModified() || this.previousConfigFileUsed != configFile) {
            this.processConfigFile(configFile);
        }
    }

    private File chooseConfigFile() {
        File result = this.checkExistenceAndReadability(this.configFileFromDomain, Level.WARNING);
        if (result == null && (result = this.checkExistenceAndReadability(this.configFileFromInstall, Level.SEVERE)) == null && !this.configFileFromInstall.exists()) {
            this.logErrorNonExistentConfig(this.configFileFromInstall);
        }
        if (result != null && this.previousConfigFileUsed != null && result != this.previousConfigFileUsed) {
            this.logUsingDifferentConfigFile(result);
        }
        return result;
    }

    private File checkExistenceAndReadability(File f, Level logLevel) {
        File result = null;
        if (f.exists()) {
            if (f.canRead()) {
                result = f;
            } else {
                this.logErrorConfigExistsButCannotRead(logLevel, f);
            }
        }
        return result;
    }

    private void logErrorConfigExistsButCannotRead(Level level, File f) {
        logger.log(level, CONFIG_UNREADABLE, f.getAbsolutePath());
    }

    private void logErrorNonExistentConfig(File f) {
        logger.log(Level.SEVERE, NO_CONFIG_FILE, f.getAbsolutePath());
    }

    private void logUsingDifferentConfigFile(File f) {
        logger.log(Level.FINE, "Changing file for client JNLP configuration; now using {0}", f.getAbsolutePath());
    }

    List<XPathToDeveloperProvidedContentRefs> xPathsToDevContentRefs() {
        this.ensureCurrent();
        return this.xPathsToDevContentRefs;
    }

    List<CombinedXPath> xPathsToCombinedContent() {
        this.ensureCurrent();
        return this.xPathsToCombinedContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConfigFile(File configFile) {
        Properties p = new Properties();
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(configFile));
            p.load(is);
            List<XPathToDeveloperProvidedContentRefs> newRefsToContent = this.prepareRefsToContent(p);
            List<CombinedXPath> newCombinedXPaths = this.prepareCombinedXPaths(p);
            this.xPathsToDevContentRefs = newRefsToContent;
            this.xPathsToCombinedContent = newCombinedXPaths;
            this.lastModified = configFile.lastModified();
            this.previousConfigFileUsed = configFile;
            logger.log(Level.FINE, "enterprise.deployment.appclient.jws.clientJNLPConfigLoad", configFile.getAbsolutePath());
        }
        catch (Exception e) {
            String fmt = logger.getResourceBundle().getString("enterprise.deployment.appclient.jws.clientJNLPConfigProcError");
            String msg = MessageFormat.format(fmt, configFile.getAbsolutePath());
            logger.log(Level.SEVERE, msg, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private List<XPathToDeveloperProvidedContentRefs> prepareRefsToContent(Properties p) {
        List<XPathToDeveloperProvidedContentRefs> result = XPathToDeveloperProvidedContentRefs.parse(p);
        return result;
    }

    private List<CombinedXPath> prepareCombinedXPaths(Properties p) {
        List<CombinedXPath> result = CombinedXPath.parse(p);
        return result;
    }
}

