/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.config.impl.extension;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.impl.extension.FileUtils;
import org.jboss.arquillian.config.impl.extension.PropertiesParser;
import org.jboss.arquillian.config.spi.ConfigurationPlaceholderResolver;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.event.ManagerStarted;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;

public class ConfigurationRegistrar {
    public static final String ARQUILLIAN_XML_PROPERTY = "arquillian.xml";
    private static final String ARQUILLIAN_XML_DEFAULT = "arquillian.xml";
    public static final String ARQUILLIAN_PROP_PROPERTY = "arquillian.properties";
    private static final String ARQUILLIAN_PROP_DEFAULT = "arquillian.properties";
    private Map<String, String> systemEnvironmentVars = System.getenv();
    @Inject
    @ApplicationScoped
    private InstanceProducer<ArquillianDescriptor> descriptorInst;
    @Inject
    private Instance<ServiceLoader> serviceLoaderInstance;

    public void loadConfiguration(@Observes ManagerStarted event) {
        ArquillianDescriptor resolvedDesc = this.loadConfiguration();
        List<ConfigurationPlaceholderResolver> configurationPlaceholderResolvers = this.loadAndOrderPlaceholderResolvers();
        for (ConfigurationPlaceholderResolver configurationPlaceholderResolver : configurationPlaceholderResolvers) {
            resolvedDesc = configurationPlaceholderResolver.resolve(resolvedDesc);
        }
        this.descriptorInst.set((Object)resolvedDesc);
    }

    public ArquillianDescriptor loadConfiguration() {
        InputStream input = FileUtils.loadArquillianXml("arquillian.xml", "arquillian.xml");
        ArquillianDescriptor descriptor = this.resolveDescriptor(input);
        PropertiesParser propertiesParser = new PropertiesParser();
        propertiesParser.addProperties(descriptor, FileUtils.loadArquillianProperties("arquillian.properties", "arquillian.properties"));
        Properties envProperties = new Properties();
        envProperties.putAll(this.systemEnvironmentVars);
        propertiesParser.addProperties(descriptor, envProperties);
        return descriptor;
    }

    private List<ConfigurationPlaceholderResolver> loadAndOrderPlaceholderResolvers() {
        ArrayList<ConfigurationPlaceholderResolver> configurationPlaceholderResolvers = new ArrayList<ConfigurationPlaceholderResolver>(((ServiceLoader)this.serviceLoaderInstance.get()).all(ConfigurationPlaceholderResolver.class));
        Collections.sort(configurationPlaceholderResolvers, new Comparator<ConfigurationPlaceholderResolver>(){

            @Override
            public int compare(ConfigurationPlaceholderResolver firstResolver, ConfigurationPlaceholderResolver secondResolver) {
                Integer a = firstResolver.precedence();
                Integer b = secondResolver.precedence();
                return b.compareTo(a);
            }
        });
        return configurationPlaceholderResolvers;
    }

    private ArquillianDescriptor resolveDescriptor(InputStream input) {
        ArquillianDescriptor descriptor = input != null ? (ArquillianDescriptor)Descriptors.importAs(ArquillianDescriptor.class).fromStream(input) : (ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class);
        return descriptor;
    }

    void setEnvironmentVariables(Map<String, String> variables) {
        this.systemEnvironmentVars = variables;
    }
}

