/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.valueextraction.declaration;

import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotBlank;
import java.util.Optional;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.Cinema;
import org.hibernate.beanvalidation.tck.tests.valueextraction.declaration.model.Reference;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ValueExtractorDeclaredInValidationXmlTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ValueExtractorDeclaredInValidationXmlTest.webArchiveBuilder().withTestClass(ValueExtractorDeclaredInValidationXmlTest.class)).withPackage(Cinema.class.getPackage())).withValidationXml("value-extractor-validation.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-validationroutine-valueextractorresolution-registering", id="b"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="k"), @SpecAssertion(section="validationapi-bootstrapping-xmlconfiguration", id="l")})
    public void canUseValueExtractorGivenInValidationXml() {
        Validator validator = Validation.byDefaultProvider().configure().buildValidatorFactory().getValidator();
        Set violations = validator.validate((Object)Cinema.invalidVisitor(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotBlank.class).withPropertyPath(ConstraintViolationAssert.pathWith().property("visitor").property("name", false, null, null, Reference.class, 0)));
        violations = validator.validate((Object)Cinema.invalidName(), new Class[0]);
        ConstraintViolationAssert.assertThat(violations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("name").containerElement("<optional>", false, null, null, Optional.class, 0));
    }
}

