/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

public final class EMFUtils {
    private EMFUtils() {
    }

    public static Collection<EClass> getSubClasses(EClass superClass) {
        HashSet<EClass> classes = new HashSet<EClass>();
        ArrayList keySet = new ArrayList(EPackage.Registry.INSTANCE.keySet());
        for (String nsURI : keySet) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || !superClass.isSuperTypeOf(eClass = (EClass)eClassifier) || eClass.isAbstract() || eClass.isInterface()) continue;
                classes.add(eClass);
            }
        }
        return classes;
    }

    public static Set<EPackage> getAllRegisteredEPackages() {
        HashSet<EPackage> ePackages = new HashSet<EPackage>();
        LinkedHashSet namespaceURIs = new LinkedHashSet(EPackage.Registry.INSTANCE.keySet());
        for (String nsURI : namespaceURIs) {
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
            ePackages.add(ePackage);
        }
        return ePackages;
    }
}

