/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.local;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.ext.fs.FileSystemUtils;
import org.eclipse.dirigible.repository.local.FileSystemRepository;
import org.eclipse.dirigible.repository.local.LocalBaseException;
import org.eclipse.dirigible.repository.local.LocalEntity;
import org.eclipse.dirigible.repository.local.LocalFile;
import org.eclipse.dirigible.repository.local.LocalFolder;
import org.eclipse.dirigible.repository.local.LocalObject;
import org.eclipse.dirigible.repository.local.LocalResource;
import org.eclipse.dirigible.repository.local.LocalWorkspaceMapper;
import org.eclipse.dirigible.repository.local.Messages;

public class LocalCollection
extends LocalEntity
implements ICollection {
    private static final String THERE_IS_NO_COLLECTION_AT_PATH_0 = Messages.getString("DBCollection.THERE_IS_NO_COLLECTION_AT_PATH_0");
    private static final String COULD_NOT_CREATE_CHILD_DOCUMENT = Messages.getString("DBCollection.COULD_NOT_CREATE_CHILD_DOCUMENT");
    private static final String COULD_NOT_GET_CHILD_RESOURCE_NAMES = Messages.getString("DBCollection.COULD_NOT_GET_CHILD_RESOURCE_NAMES");
    private static final String COULD_NOT_CREATE_CHILD_COLLECTION = Messages.getString("DBCollection.COULD_NOT_CREATE_CHILD_COLLECTION");
    private static final String COULD_NOT_GET_CHILD_COLLECTION_NAMES = Messages.getString("DBCollection.COULD_NOT_GET_CHILD_COLLECTION_NAMES");
    private static final String NOT_IMPLEMENTED = Messages.getString("DBCollection.NOT_IMPLEMENTED");
    private static final String COULD_NOT_DELETE_COLLECTION = Messages.getString("DBCollection.COULD_NOT_DELETE_COLLECTION");
    private static final String COULD_NOT_RENAME_COLLECTION = Messages.getString("DBCollection.COULD_NOT_RENAME_COLLECTION");
    private static final String CANNOT_CREATE_ROOT_COLLECTION = Messages.getString("DBCollection.CANNOT_CREATE_ROOT_COLLECTION");

    public LocalCollection(FileSystemRepository repository, RepositoryPath path) {
        super(repository, path);
    }

    public void create() throws IOException {
        ICollection parent = this.getParent();
        if (parent == null) {
            throw new LocalBaseException(CANNOT_CREATE_ROOT_COLLECTION);
        }
        parent.createCollection(this.getName());
    }

    public void delete() throws IOException {
        LocalFolder folder = this.getFolderSafe();
        try {
            folder.deleteTree();
        }
        catch (LocalBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_DELETE_COLLECTION) + this.getName(), (Throwable)((Object)ex));
        }
    }

    public void renameTo(String name) throws IOException {
        LocalFolder folder = this.getFolderSafe();
        try {
            folder.renameFolder(RepositoryPath.normalizePath((String)this.getParent().getPath(), (String)name));
        }
        catch (LocalBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_RENAME_COLLECTION) + this.getName(), (Throwable)((Object)ex));
        }
    }

    public void moveTo(String path) throws IOException {
        LocalFolder folder = this.getFolderSafe();
        try {
            folder.renameFolder(path);
        }
        catch (LocalBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_RENAME_COLLECTION) + this.getName(), (Throwable)((Object)ex));
        }
    }

    public void copyTo(String path) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    public boolean exists() throws IOException {
        String repositoryPath = this.getRepositoryPath().toString();
        if ("/".equals(repositoryPath)) {
            return true;
        }
        String localPath = LocalWorkspaceMapper.getMappedName(this.getRepository(), repositoryPath);
        return FileSystemUtils.directoryExists((String)localPath);
    }

    public boolean isEmpty() throws IOException {
        return this.getResources().isEmpty() && this.getCollections().isEmpty();
    }

    public List<ICollection> getCollections() throws IOException {
        List<String> collectionNames = this.getCollectionsNames();
        ArrayList<ICollection> result = new ArrayList<ICollection>(collectionNames.size());
        for (String collectionName : collectionNames) {
            result.add(this.getCollection(collectionName));
        }
        return result;
    }

    public List<String> getCollectionsNames() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        LocalFolder folder = this.getFolderSafe();
        try {
            for (LocalObject child : folder.getChildren()) {
                if (!(child instanceof LocalFolder)) continue;
                result.add(child.getName());
            }
        }
        catch (LocalBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_GET_CHILD_COLLECTION_NAMES) + this.getName(), (Throwable)((Object)ex));
        }
        return result;
    }

    public ICollection createCollection(String name) throws IOException {
        this.createAncestorsAndSelfIfMissing();
        LocalFolder folder = this.getFolderSafe();
        try {
            folder.createFolder(name);
        }
        catch (LocalBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_CREATE_CHILD_COLLECTION) + name, (Throwable)((Object)ex));
        }
        return this.getCollection(name);
    }

    public ICollection getCollection(String name) {
        RepositoryPath path = this.getRepositoryPath().append(name);
        return new LocalCollection(this.getRepository(), path);
    }

    public void removeCollection(String name) throws IOException {
        ICollection collection = this.getCollection(name);
        collection.delete();
    }

    public void removeCollection(ICollection childCollection) throws IOException {
        this.removeCollection(childCollection.getName());
    }

    public List<IResource> getResources() throws IOException {
        List<String> resourceNames = this.getResourcesNames();
        ArrayList<IResource> result = new ArrayList<IResource>(resourceNames.size());
        for (String resourceName : resourceNames) {
            result.add(this.getResource(resourceName));
        }
        return result;
    }

    public List<String> getResourcesNames() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        LocalFolder folder = this.getFolderSafe();
        try {
            for (LocalObject child : folder.getChildren()) {
                if (!(child instanceof LocalFile)) continue;
                result.add(child.getName());
            }
        }
        catch (LocalBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_GET_CHILD_RESOURCE_NAMES) + this.getName(), (Throwable)((Object)ex));
        }
        return result;
    }

    public IResource getResource(String name) throws IOException {
        RepositoryPath path = this.getRepositoryPath().append(name);
        return new LocalResource(this.getRepository(), path);
    }

    public IResource createResource(String name, byte[] content, boolean isBinary, String contentType) throws IOException {
        this.createAncestorsAndSelfIfMissing();
        LocalFolder folder = this.getFolderSafe();
        try {
            folder.createFile(name, content, isBinary, contentType);
        }
        catch (LocalBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_CREATE_CHILD_DOCUMENT) + name, (Throwable)((Object)ex));
        }
        return this.getResource(name);
    }

    public void removeResource(String name) throws IOException {
        IResource resource = this.getResource(name);
        resource.delete();
    }

    public void removeResource(IResource resource) throws IOException {
        this.removeResource(resource.getName());
    }

    public List<IEntity> getChildren() throws IOException {
        ArrayList<IEntity> result = new ArrayList<IEntity>();
        result.addAll(this.getCollections());
        result.addAll(this.getResources());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LocalCollection)) {
            return false;
        }
        LocalCollection other = (LocalCollection)obj;
        return this.getPath().equals(other.getPath());
    }

    @Override
    public int hashCode() {
        return this.getPath().hashCode();
    }

    protected LocalFolder getFolder() throws IOException {
        LocalObject object = this.getLocalObject();
        if (object == null) {
            return null;
        }
        if (!(object instanceof LocalFolder)) {
            return null;
        }
        return (LocalFolder)object;
    }

    protected LocalFolder getFolderSafe() throws IOException {
        LocalFolder folder = this.getFolder();
        if (folder == null) {
            throw new IOException(MessageFormat.format(THERE_IS_NO_COLLECTION_AT_PATH_0, this.getPath()));
        }
        return folder;
    }
}

