/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource.db.dialect;

import org.eclipse.dirigible.repository.datasource.db.dialect.RDBGenericDialectSpecifier;

public class SAPDBSpecifier
extends RDBGenericDialectSpecifier {
    public static final String PRODUCT_SAP_DB = "SAP DB";
    private static final String LIMIT_D_D = "LIMIT %d, %d";
    private static final String SAPDB_TIMESTAMP = "TIMESTAMP";
    private static final String SAPDB_FLOAT = "DOUBLE";
    private static final String SAPDB_BLOB = "BLOB";
    private static final String SAPDB_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    private static final String SAPDB_KEY_VARCHAR = "VARCHAR(1000)";
    private static final String SAPDB_BIG_VARCHAR = "VARCHAR(4000)";

    @Override
    public String specify(String sql) {
        sql = sql.replace("$CURRENT_TIMESTAMP$", SAPDB_CURRENT_TIMESTAMP);
        sql = sql.replace("$TIMESTAMP$", SAPDB_TIMESTAMP);
        sql = sql.replace("$BLOB$", SAPDB_BLOB);
        sql = sql.replace("$KEY_VARCHAR$", SAPDB_KEY_VARCHAR);
        sql = sql.replace("$BIG_VARCHAR$", SAPDB_BIG_VARCHAR);
        return sql;
    }

    @Override
    public String getSpecificType(String commonType) {
        if ("FLOAT".equals(commonType)) {
            return SAPDB_FLOAT;
        }
        return commonType;
    }

    @Override
    public String createLimitAndOffset(int limit, int offset) {
        return String.format(LIMIT_D_D, offset, limit);
    }

    @Override
    public String getAlterAddOpen() {
        return " ADD ";
    }

    @Override
    public boolean isDialectForName(String productName) {
        return PRODUCT_SAP_DB.equalsIgnoreCase(productName);
    }
}

