/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.editor.text.command;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.dirigible.ide.editor.text.command.Messages;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public class TextEditorHandler
extends AbstractHandler {
    private static final String COULD_NOT_OPEN_EDITOR_FOR_SOME_OR_ALL_OF_THE_SELECTED_ITEMS = Messages.TextEditorHandler_COULD_NOT_OPEN_EDITOR_FOR_SOME_OR_ALL_OF_THE_SELECTED_ITEMS;
    private static final Logger logger = Logger.getLogger(TextEditorHandler.class);
    private static final String EDITOR_ID = "org.eclipse.dirigible.ide.editor.text.editor.TextEditor";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && window != null) {
            this.execute(window.getActivePage(), (IStructuredSelection)selection);
        }
        return null;
    }

    protected String getEditorId() {
        return EDITOR_ID;
    }

    private void execute(IWorkbenchPage page, IStructuredSelection selection) {
        PartInitException error = null;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Object element = objectArray[n2];
                if (element instanceof IFile) {
                    try {
                        this.execute(page, (IFile)element);
                    }
                    catch (PartInitException ex) {
                        if (error != null) break block5;
                        error = ex;
                    }
                }
            }
            ++n2;
        }
        if (error != null) {
            logger.error(COULD_NOT_OPEN_EDITOR_FOR_SOME_OR_ALL_OF_THE_SELECTED_ITEMS, error);
            MessageDialog.openError(null, (String)Messages.TextEditorHandler_OPERATION_ERROR, (String)COULD_NOT_OPEN_EDITOR_FOR_SOME_OR_ALL_OF_THE_SELECTED_ITEMS);
        }
    }

    private void execute(IWorkbenchPage page, IFile file) throws PartInitException {
        FileEditorInput input = new FileEditorInput(file);
        page.openEditor((IEditorInput)input, this.getEditorId());
    }
}

