/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelEnvironment;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;

public final class ModelsUtil {
    private ModelsUtil() {
    }

    public static Collection<Resource> getRelatedResources(Object context_p) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        Object refinedContext = context_p;
        if (refinedContext instanceof EObject) {
            refinedContext = ((EObject)refinedContext).eResource();
        }
        if (refinedContext instanceof Resource) {
            ResourceSet rs = ((Resource)refinedContext).getResourceSet();
            if (rs == null) {
                result.add((Resource)refinedContext);
            } else {
                refinedContext = rs;
            }
        }
        if (refinedContext instanceof ResourceSet) {
            EList allResources = ((ResourceSet)refinedContext).getResources();
            IModelEnvironment accessor = CorePatternsPlugin.getDefault().getModelEnvironment();
            if (accessor == null) {
                result.addAll((Collection<Resource>)allResources);
            } else {
                for (Resource resource : allResources) {
                    if (!accessor.isModelResource(resource)) continue;
                    result.add(resource);
                }
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    public static EClass getCommonType(Collection<? extends EObject> elements_p) {
        EClass result = null;
        if (!elements_p.isEmpty()) {
            ArrayList<EClass> common = new ArrayList<EClass>(ModelsUtil.getSuperTypes(elements_p.iterator().next().eClass()));
            for (EObject eObject : elements_p) {
                common.retainAll(ModelsUtil.getSuperTypes(eObject.eClass()));
            }
            if (!common.isEmpty()) {
                result = (EClass)common.get(common.size() - 1);
            }
        }
        return result;
    }

    private static List<EClass> getSuperTypes(EClass class_p) {
        EList allButSelf = class_p.getEAllSuperTypes();
        ArrayList<EClass> result = new ArrayList<EClass>(allButSelf.size() + 1);
        result.addAll((Collection<EClass>)allButSelf);
        result.add(class_p);
        return Collections.unmodifiableList(result);
    }

    public static EditingDomain getEditingDomain(EObject element_p) {
        IModelEnvironment env = CorePatternsPlugin.getDefault().getModelEnvironment();
        if (env != null) {
            return env.getEditingDomain(element_p);
        }
        return null;
    }

    public static class RList<E>
    extends BasicEList<E> {
        private static final long serialVersionUID = -2025776878127790240L;

        public RList() {
        }

        public RList(Collection<? extends E> collection_p) {
            super(collection_p);
        }

        protected boolean useEquals() {
            return false;
        }
    }

    public static class RMap<K, V>
    extends BasicEMap<K, V> {
        private static final long serialVersionUID = -2157613781342541137L;

        public RMap() {
        }

        public RMap(Map<? extends K, ? extends V> map_p) {
            super(map_p);
        }

        public RMap(EMap<? extends K, ? extends V> map_p) {
            for (Map.Entry entry : map_p.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        protected boolean useEqualsForKey() {
            return false;
        }

        protected boolean useEqualsForValue() {
            return false;
        }
    }

    public static class ROrderedSet<E>
    extends UniqueEList<E> {
        private static final long serialVersionUID = 6139341754382438585L;

        public ROrderedSet() {
        }

        public ROrderedSet(Collection<? extends E> collection_p) {
            super(collection_p);
        }

        protected boolean useEquals() {
            return false;
        }
    }
}

