/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.core.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.diffmerge.patterns.core.Messages;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelEnvironment;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelOperation;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class AbstractModelOperation<T>
implements IModelOperation<T> {
    private static final String DEFAULT_NAME = Messages.AbstractModelOperation_DefaultName;
    private IModelEnvironment _modelEnvironment = null;
    private SubMonitor _monitor = SubMonitor.convert((IProgressMonitor)new NullProgressMonitor());
    private final String _name;
    private final ResourceSet _resourceSet;
    private final boolean _isDirtying;
    private final boolean _isExpensive;
    private final boolean _isReadOnly;
    private final Object _targetContext;
    private final Object _sourceContext;

    protected AbstractModelOperation(String name_p, ResourceSet resourceSet_p, boolean isDirtying_p, boolean isReadOnly_p, boolean isExpensive_p, Object targetContext_p, Object sourceContext_p) {
        this._name = name_p != null && name_p.length() > 0 ? name_p : DEFAULT_NAME;
        this._resourceSet = resourceSet_p;
        this._isDirtying = isDirtying_p;
        this._isReadOnly = isReadOnly_p;
        this._isExpensive = isExpensive_p;
        this._targetContext = targetContext_p;
        this._sourceContext = sourceContext_p;
    }

    protected void abort() {
        if (this._modelEnvironment != null) {
            this._modelEnvironment.abortOperation();
        }
    }

    public <U> U call(AbstractModelOperation<? extends U> operation_p) {
        operation_p.setModelEnvironment(this.getModelEnvironment());
        return operation_p.run((IProgressMonitor)this.getMonitor());
    }

    @Override
    public IModelEnvironment getModelEnvironment() {
        return this._modelEnvironment;
    }

    protected final SubMonitor getMonitor() {
        return this._monitor;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this._resourceSet;
    }

    protected int getWorkAmount() {
        return -1;
    }

    @Override
    public boolean isDirtying() {
        return this._isDirtying;
    }

    @Override
    public boolean isExpensive() {
        return this._isExpensive;
    }

    @Override
    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    protected abstract T run();

    @Override
    public T run(IProgressMonitor monitor_p) {
        if (monitor_p != null) {
            this._monitor = SubMonitor.convert((IProgressMonitor)monitor_p, (String)this.getName(), (int)this.getWorkAmount());
        }
        this._monitor.subTask(this.getName());
        return this.run();
    }

    public void setModelEnvironment(IModelEnvironment modelEnvironment_p) {
        this._modelEnvironment = modelEnvironment_p;
    }

    @Override
    public Object getTargetContext() {
        return this._targetContext;
    }

    @Override
    public Object getSourceContext() {
        return this._sourceContext;
    }
}

