/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.endo;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.IPropertyValue;
import org.eclipse.emf.diffmerge.structures.PropertyValue;
import org.eclipse.emf.diffmerge.structures.Relations;
import org.eclipse.emf.diffmerge.structures.binary.IBinaryRelation;
import org.eclipse.emf.diffmerge.structures.common.FHashMap;
import org.eclipse.emf.diffmerge.structures.common.FLinkedList;
import org.eclipse.emf.diffmerge.structures.endo.AbstractEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.ICompositeEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.IEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.TypeAdaptedEndorelation;

public class CompositeEndorelation<T, Q extends IBinaryRelation<?, ?>>
extends AbstractEndorelation<T>
implements ICompositeEndorelation.Extensible<T, Q>,
IEndorelation.RuntimeTyped<T> {
    private final Class<T> _type;
    protected final EMap<Q, IEndorelation<T>> _subRelations;

    public CompositeEndorelation(Class<T> type_p, IEqualityTester tester_p) {
        super(tester_p);
        this._type = type_p;
        this._subRelations = new FHashMap(tester_p);
    }

    @Override
    public IEndorelation<T> addSubRelation(Q subRelation_p) {
        TypeAdaptedEndorelation<T> adaptation = new TypeAdaptedEndorelation<T>((IBinaryRelation<?, ?>)subRelation_p, this.getSourceType());
        this._subRelations.put(subRelation_p, adaptation);
        return adaptation;
    }

    @Override
    public Q defaultQualifier() {
        return null;
    }

    @Override
    public Collection<T> get(T element_p) {
        return Relations.qualifiedGet(this, element_p);
    }

    @Override
    public Collection<T> get(T element_p, Q qualifier_p) {
        IEndorelation<T> adapted = this.getSubRelations().get(qualifier_p);
        Collection<Object> result = adapted != null ? adapted.get(element_p) : Collections.emptySet();
        return result;
    }

    @Override
    public Collection<Q> getQualifiers(T element_p) {
        return Relations.qualifiedGetQualifiers(this, element_p);
    }

    @Override
    public Collection<Q> getQualifiers(T source_p, T target_p) {
        FLinkedList<IBinaryRelation> result = new FLinkedList<IBinaryRelation>(this.getEqualityTester());
        for (Map.Entry<Q, IEndorelation<T>> entry : this.getSubRelations().entrySet()) {
            if (!entry.getValue().maps(source_p, target_p)) continue;
            result.add((IBinaryRelation)entry.getKey());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Class<T> getSourceType() {
        return this._type;
    }

    @Override
    public Map<Q, IEndorelation<T>> getSubRelations() {
        return Collections.unmodifiableMap(this._subRelations.map());
    }

    @Override
    public Class<T> getTargetType() {
        return this._type;
    }

    @Override
    public Map<Q, Collection<T>> getWithDetails(T element_p) {
        FHashMap result = new FHashMap();
        for (Map.Entry<Q, IEndorelation<T>> entry : this.getSubRelations().entrySet()) {
            Collection targets = entry.getValue().get(element_p);
            if (targets.isEmpty()) continue;
            result.put((IBinaryRelation)entry.getKey(), targets);
        }
        return Collections.unmodifiableMap(result.map());
    }

    @Override
    public IPropertyValue<Boolean> isIrreflexive() {
        return PropertyValue.all(this.getSubRelations().values(), this.propertyIsIrreflexive());
    }

    @Override
    public boolean maps(T source_p, T target_p, Q qualifier_p) {
        boolean result = false;
        IEndorelation<T> adapted = this.getSubRelations().get(qualifier_p);
        if (adapted != null) {
            result = adapted.maps(source_p, target_p);
        }
        return result;
    }
}

