/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfColorRef;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfRecordType;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndianInputStream;

public class HwmfDraw {
    static int readBounds(LittleEndianInputStream leis, Rectangle2D bounds) {
        short bottom = leis.readShort();
        short right = leis.readShort();
        short top = leis.readShort();
        short left = leis.readShort();
        int x = Math.min(left, right);
        int y = Math.min(top, bottom);
        int w = Math.abs(left - right - 1);
        int h = Math.abs(top - bottom - 1);
        bounds.setRect(x, y, w, h);
        return 8;
    }

    static int readRectS(LittleEndianInputStream leis, Rectangle2D bounds) {
        short left = leis.readShort();
        short top = leis.readShort();
        short right = leis.readShort();
        short bottom = leis.readShort();
        int x = Math.min(left, right);
        int y = Math.min(top, bottom);
        int w = Math.abs(left - right - 1);
        int h = Math.abs(top - bottom - 1);
        bounds.setRect(x, y, w, h);
        return 8;
    }

    static int readPointS(LittleEndianInputStream leis, Point2D point) {
        short y = leis.readShort();
        short x = leis.readShort();
        point.setLocation(x, y);
        return 4;
    }

    static String polyToString(Path2D poly) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        PathIterator iter = poly.getPathIterator(null);
        double[] pnts = new double[6];
        while (!iter.isDone()) {
            int segType = iter.currentSegment(pnts);
            switch (segType) {
                case 0: {
                    sb.append("{ type: 'move', x: " + pnts[0] + ", y: " + pnts[1] + " }, ");
                    break;
                }
                case 1: {
                    sb.append("{ type: 'lineto', x: " + pnts[0] + ", y: " + pnts[1] + " }, ");
                    break;
                }
                case 2: {
                    sb.append("{ type: 'quad', x1: " + pnts[0] + ", y1: " + pnts[1] + ", x2: " + pnts[2] + ", y2: " + pnts[3] + " }, ");
                    break;
                }
                case 3: {
                    sb.append("{ type: 'cubic', x1: " + pnts[0] + ", y1: " + pnts[1] + ", x2: " + pnts[2] + ", y2: " + pnts[3] + ", x3: " + pnts[4] + ", y3: " + pnts[5] + " }, ");
                    break;
                }
                case 4: {
                    sb.append("{ type: 'close' }, ");
                }
            }
            iter.next();
        }
        sb.append("]");
        return sb.toString();
    }

    @Internal
    public static String pointToString(Point2D point) {
        return "{ x: " + point.getX() + ", y: " + point.getY() + " }";
    }

    @Internal
    public static String boundsToString(Rectangle2D bounds) {
        return "{ x: " + bounds.getX() + ", y: " + bounds.getY() + ", w: " + bounds.getWidth() + ", h: " + bounds.getHeight() + " }";
    }

    @Internal
    public static String dimToString(Dimension2D dim) {
        return "{ w: " + dim.getWidth() + ", h: " + dim.getHeight() + " }";
    }

    @Internal
    public static Rectangle2D normalizeBounds(Rectangle2D bounds) {
        return bounds.getWidth() >= 0.0 && bounds.getHeight() >= 0.0 ? bounds : new Rectangle2D.Double(bounds.getWidth() >= 0.0 ? bounds.getMinX() : bounds.getMaxX(), bounds.getHeight() >= 0.0 ? bounds.getMinY() : bounds.getMaxY(), Math.abs(bounds.getWidth()), Math.abs(bounds.getHeight()));
    }

    public static class WmfSelectObject
    implements HwmfRecord {
        protected int objectIndex;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.selectObject;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.objectIndex = leis.readUShort();
            return 2;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.applyObjectTableEntry(this.objectIndex);
        }

        public String toString() {
            return "{ index: " + this.objectIndex + " }";
        }
    }

    public static class WmfChord
    extends WmfArc {
        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.chord;
        }
    }

    public static class WmfPie
    extends WmfArc {
        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.pie;
        }
    }

    public static class WmfArc
    implements HwmfRecord {
        protected final Point2D startPoint = new Point2D.Double();
        protected final Point2D endPoint = new Point2D.Double();
        protected final Rectangle2D bounds = new Rectangle2D.Double();

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.arc;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            HwmfDraw.readPointS(leis, this.endPoint);
            HwmfDraw.readPointS(leis, this.startPoint);
            HwmfDraw.readBounds(leis, this.bounds);
            return 16;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Arc2D s = this.getShape();
            switch (this.getFillDrawStyle()) {
                case FILL: {
                    ctx.fill(s);
                    break;
                }
                case DRAW: {
                    ctx.draw(s);
                    break;
                }
                case FILL_DRAW: {
                    ctx.fill(s);
                    ctx.draw(s);
                }
            }
        }

        protected HwmfGraphics.FillDrawStyle getFillDrawStyle() {
            switch (this.getWmfRecordType()) {
                default: {
                    return HwmfGraphics.FillDrawStyle.DRAW;
                }
                case chord: 
                case pie: 
            }
            return HwmfGraphics.FillDrawStyle.FILL_DRAW;
        }

        protected Arc2D getShape() {
            int arcClosure;
            double endAngle;
            double startAngle = Math.toDegrees(Math.atan2(-(this.startPoint.getY() - this.bounds.getCenterY()), this.startPoint.getX() - this.bounds.getCenterX()));
            double arcAngle = endAngle - startAngle + (double)((endAngle = Math.toDegrees(Math.atan2(-(this.endPoint.getY() - this.bounds.getCenterY()), this.endPoint.getX() - this.bounds.getCenterX()))) - startAngle > 0.0 ? 0 : 360);
            if (startAngle < 0.0) {
                startAngle += 360.0;
            }
            switch (this.getWmfRecordType()) {
                default: {
                    arcClosure = 0;
                    break;
                }
                case chord: {
                    arcClosure = 1;
                    break;
                }
                case pie: {
                    arcClosure = 2;
                }
            }
            return new Arc2D.Double(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight(), startAngle, arcAngle, arcClosure);
        }

        public String toString() {
            Arc2D arc = this.getShape();
            return "{ startPoint: " + HwmfDraw.pointToString(this.startPoint) + ", endPoint: " + HwmfDraw.pointToString(this.endPoint) + ", startAngle: " + arc.getAngleStart() + ", extentAngle: " + arc.getAngleExtent() + ", bounds: " + HwmfDraw.boundsToString(this.bounds) + " }";
        }
    }

    public static class WmfRoundRect
    implements HwmfRecord {
        protected int height;
        protected int width;
        protected final Rectangle2D bounds = new Rectangle2D.Double();

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.roundRect;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.height = leis.readShort();
            this.width = leis.readShort();
            return 4 + HwmfDraw.readBounds(leis, this.bounds);
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.fill(this.getShape());
        }

        protected RoundRectangle2D getShape() {
            return new RoundRectangle2D.Double(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight(), this.width, this.height);
        }
    }

    public static class WmfSetPixel
    implements HwmfRecord {
        protected final HwmfColorRef colorRef = new HwmfColorRef();
        protected final Point2D point = new Point2D.Double();

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.setPixel;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            int size = this.colorRef.init(leis);
            return size + HwmfDraw.readPointS(leis, this.point);
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Rectangle2D.Double s = new Rectangle2D.Double(this.point.getX(), this.point.getY(), 1.0, 1.0);
            ctx.fill(s);
        }
    }

    public static class WmfRectangle
    implements HwmfRecord {
        protected final Rectangle2D bounds = new Rectangle2D.Double();

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.frameRegion;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            return HwmfDraw.readBounds(leis, this.bounds);
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.fill(this.bounds);
        }

        public String toString() {
            return HwmfDraw.boundsToString(this.bounds);
        }
    }

    public static class WmfPolyPolygon
    implements HwmfRecord {
        protected final List<Path2D> polyList = new ArrayList<Path2D>();

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.polyPolygon;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            int numberOfPolygons = leis.readUShort();
            int[] pointsPerPolygon = new int[numberOfPolygons];
            int size = 2;
            for (int i = 0; i < numberOfPolygons; ++i) {
                pointsPerPolygon[i] = leis.readUShort();
                size += 2;
            }
            for (int nPoints : pointsPerPolygon) {
                Path2D.Double poly = new Path2D.Double(0, nPoints);
                for (int i = 0; i < nPoints; ++i) {
                    short x = leis.readShort();
                    short y = leis.readShort();
                    size += 4;
                    if (i == 0) {
                        ((Path2D)poly).moveTo(x, y);
                        continue;
                    }
                    ((Path2D)poly).lineTo(x, y);
                }
                poly.closePath();
                this.polyList.add(poly);
            }
            return size;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Shape shape = this.getShape(ctx);
            if (shape == null) {
                return;
            }
            switch (this.getFillDrawStyle()) {
                case DRAW: {
                    ctx.draw(shape);
                    break;
                }
                case FILL: {
                    ctx.fill(shape);
                    break;
                }
                case FILL_DRAW: {
                    ctx.fill(shape);
                    ctx.draw(shape);
                }
            }
        }

        protected HwmfGraphics.FillDrawStyle getFillDrawStyle() {
            return HwmfGraphics.FillDrawStyle.FILL_DRAW;
        }

        protected boolean isClosed() {
            return true;
        }

        protected Shape getShape(HwmfGraphics ctx) {
            int windingRule = ctx.getProperties().getWindingRule();
            if (this.isClosed()) {
                Area area = null;
                for (Path2D poly : this.polyList) {
                    Path2D p = (Path2D)poly.clone();
                    p.setWindingRule(windingRule);
                    Area newArea = new Area(p);
                    if (area == null) {
                        area = newArea;
                        continue;
                    }
                    area.exclusiveOr(newArea);
                }
                return area;
            }
            Path2D.Double path = new Path2D.Double();
            path.setWindingRule(windingRule);
            for (Path2D poly : this.polyList) {
                path.append(poly, false);
            }
            return path;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ polyList: [");
            boolean isFirst = true;
            for (Path2D p : this.polyList) {
                if (!isFirst) {
                    sb.append(",");
                }
                isFirst = false;
                sb.append("{ points: ");
                sb.append(HwmfDraw.polyToString(p));
                sb.append(" }");
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    public static class WmfFrameRegion
    implements HwmfRecord {
        protected int regionIndex;
        protected int brushIndex;
        protected int height;
        protected int width;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.frameRegion;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            this.regionIndex = leis.readUShort();
            this.brushIndex = leis.readUShort();
            this.height = leis.readShort();
            this.width = leis.readShort();
            return 8;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.applyObjectTableEntry(this.brushIndex);
            ctx.applyObjectTableEntry(this.regionIndex);
            Rectangle inner = ctx.getProperties().getRegion().getBounds();
            double x = ((RectangularShape)inner).getX() - (double)this.width;
            double y = ((RectangularShape)inner).getY() - (double)this.height;
            double w = ((RectangularShape)inner).getWidth() + (double)(2 * this.width);
            double h = ((RectangularShape)inner).getHeight() + (double)(2 * this.height);
            Rectangle2D.Double outer = new Rectangle2D.Double(x, y, w, h);
            Area frame = new Area(outer);
            frame.subtract(new Area(inner));
            ctx.fill(frame);
        }
    }

    public static class WmfEllipse
    implements HwmfRecord {
        protected final Rectangle2D bounds = new Rectangle2D.Double();

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.ellipse;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            return HwmfDraw.readBounds(leis, this.bounds);
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.fill(this.getShape());
        }

        protected Ellipse2D getShape() {
            return new Ellipse2D.Double(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
        }

        public String toString() {
            return HwmfDraw.boundsToString(this.bounds);
        }
    }

    public static class WmfPolyline
    extends WmfPolygon {
        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.polyline;
        }

        @Override
        protected HwmfGraphics.FillDrawStyle getFillDrawStyle() {
            return HwmfGraphics.FillDrawStyle.DRAW;
        }
    }

    public static class WmfPolygon
    implements HwmfRecord {
        protected Path2D poly;

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.polygon;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            int numberofPoints = leis.readShort();
            this.poly = new Path2D.Double(0, numberofPoints);
            for (int i = 0; i < numberofPoints; ++i) {
                short x = leis.readShort();
                short y = leis.readShort();
                if (i == 0) {
                    this.poly.moveTo(x, y);
                    continue;
                }
                this.poly.lineTo(x, y);
            }
            return 2 + numberofPoints * 4;
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Path2D p = (Path2D)this.poly.clone();
            p.setWindingRule(ctx.getProperties().getWindingRule());
            switch (this.getFillDrawStyle()) {
                case FILL: {
                    ctx.fill(p);
                    break;
                }
                case DRAW: {
                    ctx.draw(p);
                    break;
                }
                case FILL_DRAW: {
                    ctx.fill(p);
                    ctx.draw(p);
                }
            }
        }

        public String toString() {
            return "{ poly: " + HwmfDraw.polyToString(this.poly) + " }";
        }

        protected HwmfGraphics.FillDrawStyle getFillDrawStyle() {
            return HwmfGraphics.FillDrawStyle.FILL;
        }
    }

    public static class WmfLineTo
    implements HwmfRecord {
        protected final Point2D point = new Point2D.Double();

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.lineTo;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            return HwmfDraw.readPointS(leis, this.point);
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            Point2D start = ctx.getProperties().getLocation();
            Line2D.Double line = new Line2D.Double(start, this.point);
            ctx.draw(line);
            ctx.getProperties().setLocation(this.point);
        }

        public String toString() {
            return HwmfDraw.pointToString(this.point);
        }
    }

    public static class WmfMoveTo
    implements HwmfRecord {
        protected final Point2D point = new Point2D.Double();

        @Override
        public HwmfRecordType getWmfRecordType() {
            return HwmfRecordType.moveTo;
        }

        @Override
        public int init(LittleEndianInputStream leis, long recordSize, int recordFunction) throws IOException {
            return HwmfDraw.readPointS(leis, this.point);
        }

        @Override
        public void draw(HwmfGraphics ctx) {
            ctx.getProperties().setLocation(this.point);
        }

        public String toString() {
            return HwmfDraw.pointToString(this.point);
        }
    }
}

