/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.history.DefaultRefactoringDescriptor;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringContributionManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class RefactoringSessionReader
extends DefaultHandler {
    private String fComment = null;
    private final String fProject;
    private final boolean fCreateDefaultDescriptors;
    private List<RefactoringDescriptor> fRefactoringDescriptors = null;
    private boolean fSessionFound = false;
    private String fVersion = null;
    private Locator fLocator;

    public RefactoringSessionReader(boolean createDefaultDescriptors, String project) {
        this.fCreateDefaultDescriptors = createDefaultDescriptors;
        this.fProject = project;
    }

    private SAXParser createParser(SAXParserFactory factory) throws ParserConfigurationException, SAXException {
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        try {
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {}
        return parser;
    }

    public RefactoringSessionDescriptor readSession(InputSource source) throws CoreException {
        this.fSessionFound = false;
        try {
            source.setSystemId("/");
            this.createParser(SAXParserFactory.newInstance()).parse(source, (DefaultHandler)this);
            if (!this.fSessionFound) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10007, RefactoringCoreMessages.RefactoringSessionReader_no_session, null));
            }
            if (this.fRefactoringDescriptors != null) {
                if (this.fVersion == null || "".equals(this.fVersion)) {
                    throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10004, RefactoringCoreMessages.RefactoringSessionReader_missing_version_information, null));
                }
                if (!"1.0".equals(this.fVersion)) {
                    throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10005, RefactoringCoreMessages.RefactoringSessionReader_unsupported_version_information, null));
                }
                RefactoringSessionDescriptor refactoringSessionDescriptor = new RefactoringSessionDescriptor(this.fRefactoringDescriptors.toArray(new RefactoringDescriptor[this.fRefactoringDescriptors.size()]), this.fVersion, this.fComment);
                return refactoringSessionDescriptor;
            }
        }
        catch (SAXParseException exception) {
            String message = Messages.format(RefactoringCoreMessages.RefactoringSessionReader_invalid_contents_at, new Object[]{Integer.toString(exception.getLineNumber()), Integer.toString(exception.getColumnNumber())});
            this.throwCoreException(exception, message);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            this.throwCoreException(exception, exception.getLocalizedMessage());
        }
        finally {
            this.fRefactoringDescriptors = null;
            this.fVersion = null;
            this.fComment = null;
            this.fLocator = null;
        }
        return null;
    }

    private void throwCoreException(Exception exception, String message) throws CoreException {
        throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10006, message, (Throwable)exception));
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if ("refactoring".equals(qualifiedName)) {
            int length = attributes.getLength();
            HashMap<String, String> map = new HashMap<String, String>(length);
            String id = "";
            String stamp = "";
            String description = "";
            String comment = null;
            String flags = "0";
            String project = null;
            int index = 0;
            while (index < length) {
                String name = attributes.getQName(index);
                String value = attributes.getValue(index);
                if ("id".equals(name)) {
                    id = value;
                } else if ("stamp".equals(name)) {
                    stamp = value;
                } else if ("description".equals(name)) {
                    description = value;
                } else if ("flags".equals(name)) {
                    flags = value;
                } else if ("comment".equals(name)) {
                    if (!"".equals(value)) {
                        comment = value;
                    }
                } else if ("project".equals(name)) {
                    project = value;
                } else if (!"".equals(name)) {
                    map.put(name, value);
                }
                ++index;
            }
            int flag = 0;
            try {
                flag = Integer.parseInt(flags);
            }
            catch (NumberFormatException numberFormatException) {}
            RefactoringDescriptor descriptor = null;
            if (this.fCreateDefaultDescriptors) {
                descriptor = new DefaultRefactoringDescriptor(id, project, description, comment, map, flag);
            } else {
                if (this.fProject != null && project == null) {
                    project = this.fProject;
                }
                try {
                    descriptor = RefactoringContributionManager.getInstance().createDescriptor(id, project, description, comment, map, flag);
                }
                catch (RuntimeException e) {
                    throw new SAXParseException(RefactoringCoreMessages.RefactoringSessionReader_invalid_values_in_xml, this.fLocator, e){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public Throwable getCause() {
                            return this.getException();
                        }
                    };
                }
            }
            try {
                descriptor.setTimeStamp(Long.parseLong(stamp));
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.fRefactoringDescriptors == null) {
                this.fRefactoringDescriptors = new ArrayList<RefactoringDescriptor>();
            }
            this.fRefactoringDescriptors.add(descriptor);
        } else if ("session".equals(qualifiedName)) {
            this.fSessionFound = true;
            String version = attributes.getValue("version");
            if (version != null && !"".equals(version)) {
                this.fVersion = version;
            }
            this.fComment = attributes.getValue("comment");
        }
    }
}

