/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractVMInstallPage
extends WizardPage {
    private String fOriginalName = null;
    private IStatus fNameStatus = Status.OK_STATUS;
    private String[] fExistingNames;

    protected AbstractVMInstallPage(String pageName) {
        super(pageName);
    }

    protected AbstractVMInstallPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public abstract boolean finish();

    public abstract VMStandin getSelection();

    public void setSelection(VMStandin vm) {
        this.fOriginalName = vm.getName();
    }

    @Deprecated
    protected void nameChanged(String newName) {
        this.nameChanged(newName, false);
    }

    protected void nameChanged(String newName, boolean init) {
        this.fNameStatus = Status.OK_STATUS;
        if (newName == null || newName.trim().length() == 0) {
            if (init) {
                return;
            }
            int sev = 4;
            if (this.fOriginalName == null || this.fOriginalName.length() == 0) {
                sev = 2;
            }
            this.fNameStatus = new Status(sev, JDIDebugUIPlugin.getUniqueIdentifier(), JREMessages.addVMDialog_enterName);
        } else if (this.isDuplicateName(newName)) {
            this.fNameStatus = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), JREMessages.addVMDialog_duplicateName);
        } else {
            IStatus s = ResourcesPlugin.getWorkspace().validateName(newName, 1);
            if (!s.isOK()) {
                this.fNameStatus = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), NLS.bind((String)JREMessages.AddVMDialog_JRE_name_must_be_a_valid_file_name___0__1, (Object[])new String[]{s.getMessage()}));
            }
        }
        this.updatePageStatus();
    }

    private boolean isDuplicateName(String name) {
        if (this.fExistingNames != null) {
            String[] stringArray = this.fExistingNames;
            int n = this.fExistingNames.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                if (name.equals(n3)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void setExistingNames(String[] names) {
        this.fExistingNames = names;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    protected void setStatusMessage(IStatus status) {
        if (status.isOK()) {
            this.setMessage(status.getMessage());
        } else {
            switch (status.getSeverity()) {
                case 4: {
                    this.setMessage(status.getMessage(), 3);
                    break;
                }
                case 1: {
                    this.setMessage(status.getMessage(), 1);
                    break;
                }
                case 2: {
                    this.setMessage(status.getMessage(), 2);
                    break;
                }
            }
        }
    }

    protected IStatus getNameStatus() {
        return this.fNameStatus;
    }

    protected void updatePageStatus() {
        IStatus max = Status.OK_STATUS;
        IStatus[] iStatusArray = this.getVMStatus();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (status.getSeverity() > max.getSeverity()) {
                max = status;
            }
            ++n2;
        }
        if (this.fNameStatus.getSeverity() > max.getSeverity()) {
            max = this.fNameStatus;
        }
        if (max.isOK()) {
            this.setMessage(null, 0);
        } else {
            this.setStatusMessage(max);
        }
        this.setPageComplete(max.isOK() || max.getSeverity() == 1);
    }

    protected abstract IStatus[] getVMStatus();
}

