/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.petrinet;

import org.eclipse.comma.behavior.component.component.PredicateFunctionalConstraint;
import org.eclipse.comma.petrinet.PythonConstraintConverter;
import org.eclipse.comma.petrinet.PythonHelper;

public class PythonPFCConverter
extends PythonConstraintConverter {
    public static String convert(PredicateFunctionalConstraint constraint) {
        StringBuilder sb = new StringBuilder();
        String className = String.valueOf(constraint.getName()) + "Constraint";
        sb.append("@dataclass\n");
        sb.append("class " + className + ":\n");
        sb.append("    def take(self, event: Event, port_machine_state: Dict[str, Dict[str, str]]):\n");
        String expression = PythonHelper.expression(constraint.getExpression(), e -> {
            throw new RuntimeException("Should not be needed");
        }, e -> PythonPFCConverter.handleUnsupportedExpression(e));
        sb.append("        " + String.format("if %s:\n", expression));
        sb.append("            return self\n");
        sb.append("        else:\n");
        sb.append("            return None\n\n");
        sb.append("    def get_state(self) -> Dict[str, Any]: return {}\n\n");
        sb.append("    def set_state(self, state: Dict[str, Any]): pass\n");
        return sb.toString();
    }
}

