/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.swt.graphics.Color;

public abstract class BasePDEScanner
extends BufferedRuleBasedScanner {
    private IColorManager fColorManager;

    protected BasePDEScanner() {
    }

    public void setColorManager(IColorManager manager) {
        this.fColorManager = manager;
    }

    public BasePDEScanner(IColorManager manager) {
        this.fColorManager = manager;
        this.initialize();
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (this.affectsTextPresentation(property)) {
            Token token = this.getTokenAffected(event);
            if (property.endsWith("_bold")) {
                this.adaptToStyleChange(event, token, 1);
            } else if (property.endsWith("_italic")) {
                this.adaptToStyleChange(event, token, 2);
            } else {
                this.adaptToColorChange(event, token);
            }
        }
    }

    public abstract boolean affectsTextPresentation(String var1);

    protected abstract Token getTokenAffected(PropertyChangeEvent var1);

    protected abstract void initialize();

    protected void adaptToStyleChange(PropertyChangeEvent event, Token token, int styleAttribute) {
        TextAttribute attr;
        boolean activeValue;
        if (token == null) {
            return;
        }
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        }
        boolean bl = activeValue = ((attr = (TextAttribute)token.getData()).getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            Color foreground = attr.getForeground();
            Color background = attr.getBackground();
            int style = eventValue ? attr.getStyle() | styleAttribute : attr.getStyle() & ~styleAttribute;
            token.setData((Object)new TextAttribute(foreground, background, style));
        }
    }

    protected void adaptToColorChange(PropertyChangeEvent event, Token token) {
        TextAttribute attr = (TextAttribute)token.getData();
        token.setData((Object)new TextAttribute(this.fColorManager.getColor(event.getProperty()), attr.getBackground(), attr.getStyle()));
    }

    protected TextAttribute createTextAttribute(String property) {
        return BasePDEScanner.createTextAttribute(this.fColorManager, property);
    }

    protected static TextAttribute createTextAttribute(IColorManager manager, String property) {
        Color color = manager.getColor(property);
        int style = 0;
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean(String.valueOf(property) + "_bold")) {
            style |= 1;
        }
        if (store.getBoolean(String.valueOf(property) + "_italic")) {
            style |= 2;
        }
        return new TextAttribute(color, null, style);
    }
}

