/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class BundleJarFiles {
    private final File dependencies;

    public BundleJarFiles(File dependencies) {
        this.dependencies = dependencies;
    }

    public List<File> list() throws IOException {
        return Files.readAllLines(this.dependencies.toPath()).stream().filter(line -> line.contains("jar")).map(line -> this.recognize((String)line)).filter(Predicate.not(Optional::isEmpty)).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<File> recognize(String line) {
        Optional<File> whole = this.file(line);
        if (whole.isPresent()) {
            return whole;
        }
        String[] split = line.split(":", 2);
        if (split.length != 2) {
            return Optional.empty();
        }
        return this.recognize(split[1]);
    }

    private Optional<File> file(String segment) {
        return Optional.of(segment.trim()).filter(Predicate.not(String::isEmpty)).map(File::new).filter(File::isAbsolute).filter(File::isFile);
    }
}

