/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.launchview.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.launchview.LaunchConfigurationViewPlugin;
import org.eclipse.debug.ui.launchview.internal.LaunchViewMessages;
import org.eclipse.debug.ui.launchview.services.ILaunchObject;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DebugCoreLaunchObject
implements ILaunchObject,
Comparable<ILaunchObject> {
    private final ILaunchConfiguration config;

    public DebugCoreLaunchObject(ILaunchConfiguration config) {
        this.config = config;
    }

    @Override
    public String getId() {
        return this.config.getName();
    }

    @Override
    public StyledString getLabel() {
        return new StyledString(this.config.getName());
    }

    @Override
    public ILaunchConfigurationType getType() {
        try {
            return this.config.getType();
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).error(NLS.bind((String)LaunchViewMessages.DebugCoreLaunchObject_CannotGetType, (Object)this.config.getName()), (Throwable)e);
            return null;
        }
    }

    @Override
    public void launch(ILaunchMode mode) {
        LaunchConfigurationViewPlugin.getExecutor().launchProcess(this.config, mode.getIdentifier(), true, false, null);
    }

    @Override
    public boolean canTerminate() {
        return !DebugCoreLaunchObject.findTerminateableLaunches(this.config.getName()).isEmpty();
    }

    @Override
    public void terminate() {
        Collection<ILaunch> launches = DebugCoreLaunchObject.findTerminateableLaunches(this.config.getName());
        for (final ILaunch launch : launches) {
            Job terminateJob = new Job(NLS.bind((String)LaunchViewMessages.DebugCoreLaunchObject_Terminate, (Object)this.config.getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!launch.isTerminated()) {
                        try {
                            launch.terminate();
                        }
                        catch (DebugException debugException) {
                            return new Status(2, "org.eclipse.debug.ui.launchview", NLS.bind((String)LaunchViewMessages.DebugCoreLaunchObject_CannotTerminate, (Object)DebugCoreLaunchObject.this.config.getName()));
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            terminateJob.setUser(true);
            terminateJob.schedule();
        }
    }

    @Override
    public void relaunch() {
        ILaunch launch = DebugCoreLaunchObject.findLaunch(this.getId());
        String launchMode = launch.getLaunchMode();
        try {
            launch.terminate();
            LaunchConfigurationViewPlugin.getExecutor().launchProcess(this.config, launchMode, true, false, null);
        }
        catch (Exception e) {
            throw new RuntimeException(NLS.bind((String)LaunchViewMessages.DebugCoreLaunchObject_CannotRelaunch, (Object)this.config.getName()), e);
        }
    }

    private static ILaunch findLaunch(String name) {
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch l = iLaunchArray[n2];
            if (l.getLaunchConfiguration() != null && !l.isTerminated() && l.getLaunchConfiguration().getName().equals(name)) {
                return l;
            }
            ++n2;
        }
        return null;
    }

    private static Collection<ILaunch> findTerminateableLaunches(String name) {
        ArrayList<ILaunch> result = new ArrayList<ILaunch>();
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch l = iLaunchArray[n2];
            if (l.getLaunchConfiguration() != null && !l.isTerminated() && l.getLaunchConfiguration().getName().equals(name) && l.canTerminate()) {
                result.add(l);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public void edit() {
        ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)this.config, (String)"debug");
        if (group == null) {
            group = DebugUITools.getLaunchGroup((ILaunchConfiguration)this.config, (String)"run");
        }
        if (group != null) {
            DebugUITools.openLaunchConfigurationDialog((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)this.config, (String)group.getIdentifier(), null);
        }
    }

    @Override
    public boolean isFavorite() {
        try {
            return !this.config.getAttribute("org.eclipse.debug.ui.favoriteGroups", Collections.emptyList()).isEmpty();
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public int compareTo(ILaunchObject o) {
        if (this.getId() == null) {
            Platform.getLog(this.getClass()).warn(NLS.bind((String)LaunchViewMessages.LaunchObject_ErrorNoId, (Object)this), null);
            if (o.getId() == null) {
                return 0;
            }
            return 1;
        }
        return this.getId().compareTo(o.getId());
    }
}

