/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.java;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

public class JProcessMonitor {
    public final Process process;
    private final StringBuilder stdOut = new StringBuilder();
    private final StringBuilder stdErr = new StringBuilder();
    private final long startTime = System.nanoTime();
    private Long endTime = null;

    public JProcessMonitor(ProcessBuilder processBuilder, Consumer<String> onStdOut, Consumer<String> onStdErr) throws IOException {
        this.process = processBuilder.start();
        this.startMeasureEndTimeThread();
        this.startOutConsumerThread(this.process.getInputStream(), onStdOut, this.stdOut);
        this.startOutConsumerThread(this.process.getErrorStream(), onStdErr, this.stdErr);
    }

    public String getStdOut() {
        return this.stdOut.toString();
    }

    public String getStdErr() {
        return this.stdErr.toString();
    }

    public double getExecutionTime() {
        long time = this.endTime != null ? this.endTime : System.nanoTime();
        return (double)(time - this.startTime) / 1.0E9;
    }

    private void startMeasureEndTimeThread() {
        new Thread(){

            @Override
            public void run() {
                try {
                    JProcessMonitor.this.process.waitFor();
                    JProcessMonitor.this.endTime = System.nanoTime();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private void startOutConsumerThread(final InputStream stream, final Consumer<String> handler, final StringBuilder sb) {
        new Thread(){

            @Override
            public void run() {
                try {
                    int charsRead;
                    byte[] buffer = new byte[1024];
                    while ((charsRead = stream.read(buffer)) != -1) {
                        String text = new String(buffer, 0, charsRead);
                        sb.append(text);
                        if (handler == null) continue;
                        handler.accept(text);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }
}

