/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.validation.type;

import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.validation.type.AbstractType;
import org.eclipse.acceleo.query.validation.type.IJavaType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;

public class EClassifierType
extends AbstractType {
    private final EClassifier type;
    private final IReadOnlyQueryEnvironment queryEnvironment;

    public EClassifierType(IReadOnlyQueryEnvironment queryEnvironment, EClassifier type) {
        this.queryEnvironment = queryEnvironment;
        this.type = type;
    }

    public EClassifier getType() {
        return this.type;
    }

    @Override
    public boolean isAssignableFrom(IType otherType) {
        boolean result;
        if (!this.queryEnvironment.getEPackageProvider().isRegistered(this.type)) {
            result = false;
        } else if (this.getType() instanceof EClass && otherType.getType() instanceof EClass) {
            result = this.getType() == otherType.getType() || this.getType() == EcorePackage.eINSTANCE.getEObject() || this.queryEnvironment.getEPackageProvider().getAllSubTypes((EClass)this.getType()).contains(otherType.getType());
        } else {
            Class<?> ourClass = this.queryEnvironment.getEPackageProvider().getClass(this.getType());
            Class<?> otherClass = otherType instanceof EClassifierType ? this.queryEnvironment.getEPackageProvider().getClass(((EClassifierType)otherType).getType()) : (otherType instanceof IJavaType ? ((IJavaType)otherType).getType() : null);
            result = this.isAssignableFrom(ourClass, otherClass);
        }
        return result;
    }

    public String toString() {
        return "EClassifier=" + this.type.getName();
    }
}

