/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.Iterator;
import java.util.Map;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextIteratorProvider;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider2;
import net.sourceforge.plantuml.text.AbstractDiagramTextProvider;
import net.sourceforge.plantuml.text.TextDiagramHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractTextDiagramProvider
extends AbstractDiagramTextProvider
implements DiagramTextProvider2,
DiagramTextIteratorProvider {
    private TextDiagramHelper textDiagramHelper = null;

    public AbstractTextDiagramProvider() {
        this.setEditorType(ITextEditor.class);
    }

    public boolean supportsSelection(ISelection selection) {
        return selection instanceof ITextSelection;
    }

    @Override
    protected String getDiagramText(IEditorPart editorPart, IEditorInput editorInput, ISelection selection, Map<String, Object> markerAttributes) {
        StringBuilder lines = this.getDiagramTextLines(editorPart, editorInput, selection, markerAttributes);
        return lines != null ? this.getDiagramText(lines) : null;
    }

    protected String getStartPlantUmlRegex() {
        return "@startuml";
    }

    protected String getEndPlantUmlRegex() {
        return "@enduml";
    }

    public TextDiagramHelper getTextDiagramHelper() {
        if (this.textDiagramHelper == null) {
            this.textDiagramHelper = new TextDiagramHelper(this.getStartPlantUml(), this.getStartPlantUmlRegex(), this.getEndPlantUml(), this.getEndPlantUmlRegex());
        }
        return this.textDiagramHelper;
    }

    protected StringBuilder getDiagramTextLines(IEditorPart editorPart, IEditorInput editorInput, ISelection selection, Map<String, Object> markerAttributes) {
        ITextEditor textEditor = (ITextEditor)editorPart;
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)editorInput);
        int selectionStart = ((ITextSelection)(selection != null ? selection : textEditor.getSelectionProvider().getSelection())).getOffset();
        return this.getTextDiagramHelper().getDiagramTextLines(document, selectionStart, markerAttributes);
    }

    public String getDiagramText(CharSequence lines) {
        return this.getDiagramText(new StringBuilder(lines.toString()));
    }

    protected String getDiagramText(StringBuilder lines) {
        return this.getTextDiagramHelper().getDiagramText(lines);
    }

    public String getDiagramText(IPath path) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (file != null && file.exists()) {
            return this.getTextDiagramHelper().getDiagramText(file);
        }
        return null;
    }

    public Iterator<ISelection> getDiagramText(IEditorPart editorPart) {
        IDocument document = ((ITextEditor)editorPart).getDocumentProvider().getDocument((Object)editorPart.getEditorInput());
        return this.getTextDiagramHelper().getDiagramText(document);
    }
}

