/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.eclipse.Activator;
import net.sourceforge.plantuml.eclipse.utils.LinkData;
import net.sourceforge.plantuml.eclipse.utils.WorkbenchUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;

public class Diagram {
    private String textDiagram;
    private int imageCount;
    private static FileFormatOption layoutFormatOption = new FileFormatOption(FileFormat.PNG);
    private final Pattern pattern = Pattern.compile("(?i)(?m)^\\W*newpage( .*)?$");

    public ImageData getImage(IPath path, int imageNum, Collection<LinkData> links) throws IOException {
        if (this.textDiagram != null) {
            if (path != null) {
                IFile member = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                File dirPath = member.getLocation().toFile().getAbsoluteFile().getParentFile();
                FileSystem.getInstance().setCurrentDir(dirPath);
            } else {
                FileSystem.getInstance().reset();
            }
            OptionFlags.getInstance().setQuiet(true);
            return Diagram.getImage(this.textDiagram, imageNum, links);
        }
        return null;
    }

    private static void setGraphvizPath() {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        String dotPath = prefStore.getString("graphvizPath");
        if (dotPath != null && !"".equals(dotPath)) {
            System.setProperty("GRAPHVIZ_DOT", dotPath);
        }
    }

    public static ImageData getImage(String textDiagram) {
        return Diagram.getImage(textDiagram, 0, null);
    }

    private static ImageData getImage(String textDiagram, int imageNum, Collection<LinkData> links) {
        ImageData imageData;
        block21: {
            Diagram.setGraphvizPath();
            imageData = null;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    String cMapData;
                    SourceStringReader reader = new SourceStringReader(textDiagram);
                    DiagramDescription desc = reader.outputImage((OutputStream)os, imageNum);
                    if (links != null && (cMapData = reader.getCMapData(0, layoutFormatOption)) != null) {
                        Diagram.parseImageMapString(cMapData, links);
                    }
                    os.flush();
                    if (desc == null || !StringUtils.isNotEmpty((String)desc.getDescription())) break block21;
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());){
                        imageData = new ImageData((InputStream)is);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                WorkbenchUtil.errorBox("Error during image generation.", e);
            }
        }
        return imageData;
    }

    private static void parseImageMapString(String cMapData, Collection<LinkData> links) {
        String[] areaElements;
        String[] stringArray = areaElements = cMapData.split(Pattern.quote("<area "));
        int n = areaElements.length;
        int n2 = 0;
        while (n2 < n) {
            String[] ints;
            String areaElement = stringArray[n2];
            LinkData link = new LinkData();
            link.href = Diagram.getAttributeValue(areaElement, "href");
            link.title = Diagram.getAttributeValue(areaElement, "title");
            link.altText = Diagram.getAttributeValue(areaElement, "alt");
            String coords = Diagram.getAttributeValue(areaElement, "coords");
            if (coords != null && (ints = coords.split(",")).length == 4) {
                try {
                    int x1 = Integer.valueOf(ints[0]);
                    int y1 = Integer.valueOf(ints[1]);
                    int x2 = Integer.valueOf(ints[2]);
                    int y2 = Integer.valueOf(ints[3]);
                    link.rect = new Rectangle(x1, y1, x2 - x1, y2 - y1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            links.add(link);
            ++n2;
        }
    }

    private static String getAttributeValue(String element, String attributeName) {
        String prefix = String.valueOf(attributeName) + "=\"";
        int start = element.indexOf(prefix);
        if (start >= 0) {
            String suffix = "\"";
            int end = element.indexOf("\"", start += prefix.length());
            if (end > start) {
                return element.substring(start, end);
            }
        }
        return null;
    }

    public void setTextDiagram(String diagramText) {
        this.textDiagram = diagramText;
        if (this.textDiagram != null) {
            this.imageCount = 1;
            Matcher matcherNewpage = this.pattern.matcher(diagramText);
            while (matcherNewpage.find()) {
                ++this.imageCount;
            }
        }
    }

    public String getTextDiagram() {
        return this.textDiagram;
    }

    public int getImageCount() {
        return this.imageCount;
    }
}

