/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search2.internal.ui.SearchMessages;

public class SearchPageRegistry {
    public static final String ID_EXTENSION_POINT = "org.eclipse.search.searchResultViewPages";
    public static final String ATTRIB_SEARCH_RESULT_CLASS = "searchResultClass";
    public static final String ATTRIB_ID = "id";
    public static final String ATTRIB_LABEL = "label";
    public static final String ATTRIB_ICON = "icon";
    public static final String ATTRIB_HELP_CONTEXT = "helpContextId";
    private final Map<String, IConfigurationElement> fResultClassNameToExtension;
    private final Map<IConfigurationElement, ISearchResultPage> fExtensionToInstance = new HashMap<IConfigurationElement, ISearchResultPage>();
    private final IConfigurationElement[] fExtensions;

    public SearchPageRegistry() {
        this.fResultClassNameToExtension = new HashMap<String, IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = this.fExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(ID_EXTENSION_POINT);
        int n = this.fExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement fExtension = iConfigurationElementArray[n2];
            this.fResultClassNameToExtension.put(fExtension.getAttribute(ATTRIB_SEARCH_RESULT_CLASS), fExtension);
            ++n2;
        }
    }

    public ISearchResultPage findPageForSearchResult(ISearchResult result, boolean create) {
        Class<?> resultClass = result.getClass();
        IConfigurationElement configElement = this.findConfigurationElement(resultClass);
        if (configElement != null) {
            return this.getSearchResultPage(configElement, create);
        }
        return null;
    }

    public ISearchResultPage findPageForPageId(String pageId, boolean create) {
        IConfigurationElement configElement = this.findConfigurationElement(pageId);
        if (configElement != null) {
            return this.getSearchResultPage(configElement, create);
        }
        return null;
    }

    public String findLabelForPageId(String pageId) {
        IConfigurationElement configElement = this.findConfigurationElement(pageId);
        if (configElement != null) {
            return configElement.getAttribute(ATTRIB_LABEL);
        }
        return null;
    }

    public String getHelpContextId(String pageId) {
        IConfigurationElement configElement = this.findConfigurationElement(pageId);
        if (configElement != null) {
            return configElement.getAttribute(ATTRIB_HELP_CONTEXT);
        }
        return null;
    }

    private ISearchResultPage getSearchResultPage(final IConfigurationElement configElement, boolean create) {
        ISearchResultPage instance = this.fExtensionToInstance.get(configElement);
        if (instance == null && create) {
            final Object[] result = new Object[1];
            SafeRunnable safeRunnable = new SafeRunnable(SearchMessages.SearchPageRegistry_error_creating_extensionpoint){

                public void run() throws Exception {
                    result[0] = configElement.createExecutableExtension("class");
                }

                public void handleException(Throwable e) {
                    SearchPlugin.log(e);
                }
            };
            SafeRunner.run((ISafeRunnable)safeRunnable);
            if (result[0] instanceof ISearchResultPage) {
                instance = (ISearchResultPage)result[0];
                instance.setID(configElement.getAttribute(ATTRIB_ID));
                this.fExtensionToInstance.put(configElement, instance);
            }
        }
        return instance;
    }

    private IConfigurationElement findConfigurationElement(String pageId) {
        IConfigurationElement[] iConfigurationElementArray = this.fExtensions;
        int n = this.fExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement curr = iConfigurationElementArray[n2];
            if (pageId.equals(curr.getAttribute(ATTRIB_ID))) {
                return curr;
            }
            ++n2;
        }
        return null;
    }

    private IConfigurationElement findConfigurationElement(Class<?> resultClass) {
        Class<?>[] interfaces;
        IConfigurationElement foundExtension;
        String className = resultClass.getName();
        IConfigurationElement configElement = this.fResultClassNameToExtension.get(className);
        if (configElement != null) {
            return configElement;
        }
        Class<?> superclass = resultClass.getSuperclass();
        if (superclass != null && (foundExtension = this.findConfigurationElement(superclass)) != null) {
            this.fResultClassNameToExtension.put(className, configElement);
            return foundExtension;
        }
        Class<?>[] classArray = interfaces = resultClass.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interface1 = classArray[n2];
            IConfigurationElement foundExtension2 = this.findConfigurationElement(interface1);
            if (foundExtension2 != null) {
                this.fResultClassNameToExtension.put(className, configElement);
                return foundExtension2;
            }
            ++n2;
        }
        return null;
    }
}

