/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.dependencies;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesView;

public class DependenciesViewPageContentProvider
implements IContentProvider,
IPluginModelListener {
    private DependenciesView fView;
    private StructuredViewer fViewer;

    public DependenciesViewPageContentProvider(DependenciesView view) {
        this.fView = view;
        this.attachModelListener();
    }

    public void attachModelListener() {
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
    }

    public void removeModelListener() {
        PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
    }

    public void dispose() {
        this.removeModelListener();
    }

    private void handleModifiedModels(ModelEntry[] modified) {
        Object input = this.fViewer.getInput();
        if (input instanceof IPluginModelBase) {
            BundleDescription desc = ((IPluginModelBase)input).getBundleDescription();
            String inputID = desc != null ? desc.getSymbolicName() : ((IPluginModelBase)input).getPluginBase().getId();
            ModelEntry[] modelEntryArray = modified;
            int n = modified.length;
            int n2 = 0;
            while (n2 < n) {
                ModelEntry entry = modelEntryArray[n2];
                if (entry.getId().equals(inputID)) {
                    if (this.modelExists(entry, (IPluginModelBase)input)) {
                        this.fView.updateTitle(input);
                    } else {
                        this.fView.openTo(null);
                    }
                    return;
                }
                ++n2;
            }
        }
    }

    private boolean modelExists(ModelEntry entry, IPluginModelBase input) {
        IPluginModelBase[][] entries = new IPluginModelBase[][]{entry.getExternalModels(), entry.getWorkspaceModels()};
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < entries[i].length) {
                if (entries[i][j].equals(input)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fView.updateTitle(newInput);
        this.fViewer = (StructuredViewer)viewer;
    }

    public void modelsChanged(PluginModelDelta delta) {
        if (this.fViewer == null || this.fViewer.getControl().isDisposed()) {
            return;
        }
        this.fViewer.getControl().getDisplay().asyncExec(() -> {
            int kind = delta.getKind();
            if (this.fViewer.getControl().isDisposed()) {
                return;
            }
            try {
                if ((kind & 2) != 0) {
                    this.handleModifiedModels(delta.getRemovedEntries());
                }
                if ((kind & 4) != 0) {
                    this.handleModifiedModels(delta.getChangedEntries());
                }
                if ((kind & 1) != 0) {
                    this.handleModifiedModels(delta.getAddedEntries());
                }
            }
            finally {
                this.fViewer.refresh();
            }
        });
    }
}

