/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import org.eclipse.comma.monitoring.dashboard.DashboardHelper;
import org.eclipse.comma.monitoring.lib.CTaskResults;
import org.eclipse.comma.monitoring.lib.ExportResults;

public class ExportToDashboard
implements ExportResults {
    private static final String RESULTS_PATH = "comma-gen" + File.separator;

    @Override
    public void export(List<CTaskResults> taskResults) {
        File file = new File(String.valueOf(RESULTS_PATH) + "dashboard.html");
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        JsonElement element = gson.toJsonTree(taskResults);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream stream = new FileOutputStream(file);){
                this.addStatistics(element);
                this.replaceUmlFileWithBase64(element);
                byte[] resultsInJson = gson.toJson(element).getBytes(StandardCharsets.UTF_8);
                byte[] dashboardHTML = DashboardHelper.getHTML();
                if (dashboardHTML != null) {
                    byte[] placeholder = "\"%MONITORING_TASKS%\"".getBytes(StandardCharsets.UTF_8);
                    int placeholderStart = 0;
                    int placeholderIndex = 0;
                    int i = 0;
                    while (i < dashboardHTML.length) {
                        if (dashboardHTML[i] == placeholder[placeholderIndex]) {
                            if (placeholderIndex == 0) {
                                placeholderStart = i;
                            } else if (placeholderIndex == placeholder.length - 1) break;
                            ++placeholderIndex;
                        } else {
                            placeholderIndex = 0;
                        }
                        ++i;
                    }
                    stream.write(Arrays.copyOfRange(dashboardHTML, 0, placeholderStart));
                    stream.write(resultsInJson);
                    stream.write(Arrays.copyOfRange(dashboardHTML, placeholderStart + placeholder.length, dashboardHTML.length));
                } else {
                    String content = "Dashboard not present, likely you forgot to build Comma with the -Pdashboard flag, see developing.md";
                    stream.write(content.getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addStatistics(JsonElement root) throws IOException {
        for (JsonElement task : root.getAsJsonArray()) {
            JsonArray statisticsJson = new JsonArray();
            String name = task.getAsJsonObject().get("taskName").getAsString();
            File statistics = new File(String.valueOf(RESULTS_PATH) + name + File.separator + "statistics");
            if (statistics.exists()) {
                String[] stringArray = statistics.list();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String statistic = stringArray[n2];
                    Path statisticPath = Paths.get(statistics.getPath(), statistic);
                    JsonArray content = new JsonArray();
                    String[] stringArray2 = Files.readString(statisticPath).split("\n");
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String line = stringArray2[n4];
                        content.add(line);
                        ++n4;
                    }
                    JsonObject statisticJson = new JsonObject();
                    statisticJson.addProperty("file", statisticPath.getFileName().toString());
                    statisticJson.add("content", (JsonElement)content);
                    statisticsJson.add((JsonElement)statisticJson);
                    ++n2;
                }
            }
            task.getAsJsonObject().add("statistics", (JsonElement)statisticsJson);
        }
    }

    private String renderUmlFileAsBase64(String umlFile) throws IOException {
        String content = Files.readString(Paths.get(umlFile, new String[0]));
        SourceStringReader reader = new SourceStringReader(content);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        reader.outputImage((OutputStream)os, new FileFormatOption(FileFormat.PNG));
        return Base64.getEncoder().encodeToString(os.toByteArray());
    }

    private void replaceUmlFileWithBase64(Object object) throws IOException {
        block4: {
            block3: {
                if (!(object instanceof JsonArray)) break block3;
                JsonArray jsonArray = (JsonArray)object;
                int i = 0;
                while (i < jsonArray.size()) {
                    this.replaceUmlFileWithBase64(jsonArray.get(i));
                    ++i;
                }
                break block4;
            }
            if (!(object instanceof JsonObject)) break block4;
            JsonObject jsonObject = (JsonObject)object;
            for (String key : jsonObject.keySet()) {
                if (key.equals("umlFile")) {
                    String umlFile = jsonObject.get(key).getAsString();
                    String base64 = this.renderUmlFileAsBase64(umlFile);
                    jsonObject.addProperty("umlBase64", base64);
                    jsonObject.remove(key);
                    continue;
                }
                this.replaceUmlFileWithBase64(jsonObject.get(key));
            }
        }
    }
}

