/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor.hover;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.internal.genericeditor.hover.CompositeInformationControlCreator;

public class CompositeInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2 {
    final LinkedHashMap<ITextHover, IInformationControlCreator> creators;
    LinkedHashMap<ITextHover, IInformationControl> controls;

    public CompositeInformationControl(Shell parentShell, LinkedHashMap<ITextHover, IInformationControlCreator> creators) {
        super(parentShell, true);
        Assert.isLegal((creators.size() > 1 ? 1 : 0) != 0, (String)"Do not compose a unique hover");
        this.creators = creators;
        this.create();
    }

    public boolean hasContents() {
        for (IInformationControl control : this.controls.values()) {
            if (control instanceof IInformationControlExtension) {
                if (!((IInformationControlExtension)control).hasContents()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public void setInput(Object input) {
        Map inputs = (Map)input;
        for (Map.Entry entry : inputs.entrySet()) {
            IInformationControl informationControl = this.controls.get(entry.getKey());
            if (informationControl == null) continue;
            if (informationControl instanceof IInformationControlExtension2) {
                ((IInformationControlExtension2)informationControl).setInput(entry.getValue());
                continue;
            }
            String information = entry.getValue().toString();
            if (information.isEmpty()) continue;
            informationControl.setInformation(information);
        }
    }

    public void createContent(Composite parent) {
        this.controls = new LinkedHashMap();
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        for (Map.Entry<ITextHover, IInformationControlCreator> hoverControlCreator : this.creators.entrySet()) {
            IInformationControl informationControl = hoverControlCreator.getValue().createInformationControl(parent.getShell());
            if (informationControl instanceof AbstractInformationControl) {
                List<Control> children = Arrays.asList(((AbstractInformationControl)informationControl).getShell().getChildren());
                children.remove(parent);
                if (children.isEmpty()) continue;
                for (Control control : children) {
                    control.setParent(parent);
                }
                this.controls.put(hoverControlCreator.getKey(), informationControl);
                continue;
            }
            GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ui.genericeditor", "Only text hovers producing an AbstractInformationControl can be aggregated; got a " + informationControl.getClass().getSimpleName()));
            informationControl.dispose();
        }
    }

    public void dispose() {
        this.controls.values().forEach(IInformationControl::dispose);
        this.controls.clear();
        super.dispose();
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.controls.isEmpty()) {
            return null;
        }
        if (this.controls.size() == 1) {
            IInformationControl control = this.controls.values().iterator().next();
            if (control instanceof IInformationControlExtension5) {
                return ((IInformationControlExtension5)control).getInformationPresenterControlCreator();
            }
        } else {
            LinkedHashMap<ITextHover, IInformationControlCreator> presenterCreators = new LinkedHashMap<ITextHover, IInformationControlCreator>();
            boolean allNull = true;
            for (Map.Entry<ITextHover, IInformationControl> hover : this.controls.entrySet()) {
                IInformationControlCreator creator = null;
                if (hover.getValue() instanceof IInformationControlExtension5) {
                    creator = ((IInformationControlExtension5)hover.getValue()).getInformationPresenterControlCreator();
                }
                if (creator == null) {
                    creator = this.creators.get(hover.getKey());
                } else {
                    allNull = false;
                }
                if (creator == null) continue;
                presenterCreators.put(hover.getKey(), creator);
            }
            if (allNull) {
                return null;
            }
            return new CompositeInformationControlCreator(presenterCreators);
        }
        return null;
    }

    public Point computeSizeHint() {
        return this.getShell().computeSize(-1, -1, true);
    }
}

