/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor;

import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.XMLInputContext;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;

public class DSInputContext
extends XMLInputContext {
    public static final String CONTEXT_ID = "ds-context";

    public DSInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    protected void reorderInsertEdits(ArrayList<TextEdit> ops) {
    }

    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        if (input instanceof IStorageEditorInput) {
            boolean isReconciling = input instanceof IFileEditorInput;
            IDocument document = this.getDocumentProvider().getDocument((Object)input);
            DSModel model = new DSModel(document, isReconciling);
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                model.setUnderlyingResource((IResource)file);
                model.setCharset(Charset.forName(file.getCharset()));
            } else if (input instanceof IURIEditorInput) {
                IFileStore store = EFS.getStore((URI)((IURIEditorInput)input).getURI());
                model.setInstallLocation(store.getParent().toString());
                model.setCharset(this.getDefaultCharset());
            } else if (input instanceof JarEntryEditorInput) {
                File file = (File)((JarEntryEditorInput)input).getAdapter(File.class);
                model.setInstallLocation(file.toString());
                model.setCharset(this.getDefaultCharset());
            } else {
                model.setCharset(this.getDefaultCharset());
            }
            model.load();
            return model;
        }
        return null;
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected String getPartitionName() {
        return "___ds_partition";
    }
}

