/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.text.edits.TextEditGroup;

public class PlainReplacementFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<PlainReplacementFixOperation> operations = new ArrayList<PlainReplacementFixOperation>();
        PlainReplacementFinder finder = new PlainReplacementFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new PlainReplacementFixCore(FixMessages.PlainReplacementFix_use_plain_text, compilationUnit, ops);
    }

    protected PlainReplacementFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static String toPlainString(String regexOrReplacement, boolean isRegex, boolean doUnescape) {
        boolean isEscaped = false;
        StringBuilder plainString = null;
        int i = 0;
        while (i < regexOrReplacement.length()) {
            char c = regexOrReplacement.charAt(i);
            if (Character.isSurrogate(c)) {
                return null;
            }
            if (PlainReplacementFixCore.isMetaChar(c, isRegex)) {
                if (isEscaped) {
                    if (plainString == null) {
                        if (!doUnescape) {
                            return null;
                        }
                        plainString = new StringBuilder();
                        if (i > 1) {
                            plainString.append(regexOrReplacement, 0, i - 1);
                        }
                    }
                    plainString.append(c);
                } else if (c != '\\') {
                    return null;
                }
            } else if (isEscaped) {
                if (isRegex || !doUnescape && !PlainReplacementFixCore.isMetaChar(c, false)) {
                    return null;
                }
                if (!PlainReplacementFixCore.isMetaChar(c, false)) {
                    if (plainString == null) {
                        plainString = new StringBuilder();
                        if (i > 1) {
                            plainString.append(regexOrReplacement, 0, i - 1);
                        }
                    }
                    plainString.append(c);
                }
            } else if (plainString != null) {
                plainString.append(c);
            }
            isEscaped = !isEscaped && c == '\\';
            ++i;
        }
        return isEscaped ? null : (plainString == null ? regexOrReplacement : plainString.toString());
    }

    private static boolean isMetaChar(char c, boolean isRegex) {
        if (isRegex) {
            return c == '.' || c == '$' || c == '|' || c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}' || c == '^' || c == '?' || c == '*' || c == '+' || c == '\\';
        }
        return c == '$' || c == '\\';
    }

    public static final class PlainReplacementFinder
    extends ASTVisitor {
        private List<PlainReplacementFixOperation> fResult;

        public PlainReplacementFinder(List<PlainReplacementFixOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(MethodInvocation visited) {
            if (ASTNodes.usesGivenSignature(visited, String.class.getCanonicalName(), "replaceAll", String.class.getCanonicalName(), String.class.getCanonicalName()) && this.isPlainStringArgument(visited, true, 0, Pattern.class, "quote") && this.isPlainStringArgument(visited, false, 1, Matcher.class, "quoteReplacement")) {
                this.fResult.add(new PlainReplacementFixOperation(visited));
                if (visited.getExpression() != null) {
                    visited.getExpression().accept((ASTVisitor)this);
                }
                return false;
            }
            return true;
        }

        private boolean isPlainStringArgument(MethodInvocation visited, boolean isRegex, int index, Class<?> klass, String methodName) {
            Expression argument = (Expression)visited.arguments().get(index);
            if (argument instanceof MethodInvocation && ASTNodes.usesGivenSignature((MethodInvocation)argument, klass.getCanonicalName(), methodName, String.class.getCanonicalName())) {
                return true;
            }
            Object argumentResolved = argument.resolveConstantExpressionValue();
            return argumentResolved instanceof String && PlainReplacementFixCore.toPlainString((String)argumentResolved, isRegex, argument instanceof StringLiteral) != null;
        }
    }

    public static class PlainReplacementFixOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final MethodInvocation visited;

        public PlainReplacementFixOperation(MethodInvocation visited) {
            this.visited = visited;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.PlainReplacementCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            rewrite.set((ASTNode)this.visited, (StructuralPropertyDescriptor)MethodInvocation.NAME_PROPERTY, (Object)ast.newSimpleName("replace"), group);
            String arg1 = this.tryToSimplifyStringLiteralArgument(true, ast, rewrite, group);
            String arg2 = this.tryToSimplifyStringLiteralArgument(false, ast, rewrite, group);
            if (arg1 != null && arg2 != null && arg1.length() == 1 && arg2.length() == 1) {
                this.convertStringLiteralArgumentToChar(true, arg1, ast, rewrite, group);
                this.convertStringLiteralArgumentToChar(false, arg2, ast, rewrite, group);
            } else {
                this.useQuotedArgumentWhenPossible(true, rewrite, group);
                this.useQuotedArgumentWhenPossible(false, rewrite, group);
            }
        }

        private String tryToSimplifyStringLiteralArgument(boolean isRegex, AST ast, ASTRewrite rewrite, TextEditGroup group) {
            int index = isRegex ? 0 : 1;
            Expression argument = (Expression)this.visited.arguments().get(index);
            if (!(argument instanceof StringLiteral)) {
                return null;
            }
            String argumentResolved = (String)argument.resolveConstantExpressionValue();
            String asPlainString = PlainReplacementFixCore.toPlainString(argumentResolved, isRegex, true);
            if (asPlainString == null) {
                return null;
            }
            if (argumentResolved.equals(asPlainString)) {
                return argumentResolved;
            }
            StringLiteral dummyStringLiteral = ast.newStringLiteral();
            dummyStringLiteral.setLiteralValue(asPlainString);
            rewrite.set((ASTNode)((StringLiteral)this.visited.arguments().get(index)), (StructuralPropertyDescriptor)StringLiteral.ESCAPED_VALUE_PROPERTY, (Object)dummyStringLiteral.getEscapedValue(), group);
            return asPlainString;
        }

        private void convertStringLiteralArgumentToChar(boolean isRegex, String string, AST ast, ASTRewrite rewrite, TextEditGroup group) {
            int index = isRegex ? 0 : 1;
            CharacterLiteral characterLiteral = ast.newCharacterLiteral();
            characterLiteral.setCharValue(string.charAt(0));
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.visited.arguments().get(index), (ASTNode)characterLiteral, group);
        }

        private void useQuotedArgumentWhenPossible(boolean isRegex, ASTRewrite rewrite, TextEditGroup group) {
            int index = isRegex ? 0 : 1;
            Expression argument = (Expression)this.visited.arguments().get(index);
            if (argument instanceof MethodInvocation) {
                Expression quoteExpr = (Expression)((MethodInvocation)argument).arguments().get(0);
                ASTNodes.replaceButKeepComment(rewrite, (ASTNode)argument, (ASTNode)ASTNodes.createMoveTarget(rewrite, quoteExpr), group);
            }
        }
    }
}

