/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.launch;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;

public abstract class JavaElementResolver {
    protected abstract Collection<IJavaElement> findJavaElements();

    public final List<IMethod> resolveMethods() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (IJavaElement javaElement : this.findJavaElements()) {
            Optional<IMethod> method = this.resolveMethod(javaElement);
            if (!method.isPresent()) continue;
            result.add(method.get());
        }
        return result.build();
    }

    private Optional<IMethod> resolveMethod(IJavaElement javaElement) {
        if (javaElement.getJavaProject() == null || javaElement.getJavaProject().getProject() == null) {
            return Optional.absent();
        }
        if (javaElement instanceof IMethod) {
            IMethod method = (IMethod)javaElement;
            if (method.getDeclaringType() == null) {
                return Optional.absent();
            }
            return Optional.of((Object)method);
        }
        return Optional.absent();
    }

    public final List<IType> resolveTypes() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (IJavaElement javaElement : this.findJavaElements()) {
            Optional<IType> type = this.resolveType(javaElement);
            if (!type.isPresent()) continue;
            result.add(type.get());
        }
        return result.build();
    }

    private Optional<IType> resolveType(IJavaElement javaElement) {
        if (javaElement.getJavaProject() == null || javaElement.getJavaProject().getProject() == null) {
            return Optional.absent();
        }
        IType result = null;
        switch (javaElement.getElementType()) {
            case 7: {
                result = (IType)javaElement;
                break;
            }
            case 8: {
                result = ((IField)javaElement).getDeclaringType();
                break;
            }
            case 5: 
            case 6: {
                result = ((ITypeRoot)javaElement).findPrimaryType();
                break;
            }
            case 9: {
                result = ((IMethod)javaElement).getDeclaringType();
            }
        }
        return Optional.fromNullable(result);
    }
}

