/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.gradleware.tooling.toolingclient.Consumer;
import com.gradleware.tooling.toolingclient.Request;
import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.internal.Converter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseModelRepository
implements ModelRepository {
    private final ToolingClient toolingClient;
    private final EventBus eventBus;
    private final Cache<Class<?>, Object> cache;

    public BaseModelRepository(ToolingClient toolingClient, EventBus eventBus) {
        this.toolingClient = (ToolingClient)Preconditions.checkNotNull((Object)toolingClient);
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.cache = CacheBuilder.newBuilder().build();
    }

    @Override
    public void register(Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.eventBus.register(listener);
    }

    @Override
    public void unregister(Object listener) {
        Preconditions.checkNotNull((Object)listener);
        this.eventBus.unregister(listener);
    }

    protected ToolingClient getToolingClient() {
        return this.toolingClient;
    }

    protected void postEvent(Object event) {
        this.eventBus.post(event);
    }

    protected <T, U> U executeRequest(final Request<T> request, Consumer<U> newCacheEntryHandler, FetchStrategy fetchStrategy, Class<U> cacheKey, Converter<T, U> resultConverter) {
        return this.executeRequest(new Supplier<T>(){

            public T get() {
                return request.executeAndWait();
            }
        }, newCacheEntryHandler, fetchStrategy, cacheKey, resultConverter);
    }

    protected <T, U> U executeRequest(final Supplier<T> operation, Consumer<U> newCacheEntryHandler, FetchStrategy fetchStrategy, Class<U> cacheKey, final Converter<T, U> resultConverter) {
        if (FetchStrategy.FROM_CACHE_ONLY == fetchStrategy) {
            Object result = this.cache.getIfPresent(cacheKey);
            return cacheKey.cast(result);
        }
        if (FetchStrategy.FORCE_RELOAD == fetchStrategy) {
            this.cache.invalidate(cacheKey);
        }
        final AtomicBoolean modelLoaded = new AtomicBoolean(false);
        U value = this.getFromCache(cacheKey, new Callable<U>(){

            @Override
            public U call() {
                Object model = BaseModelRepository.this.executeAndWait(operation, resultConverter);
                modelLoaded.set(true);
                return model;
            }
        });
        if (modelLoaded.get()) {
            newCacheEntryHandler.accept(value);
        }
        return value;
    }

    private <U> U getFromCache(Class<U> cacheKey, Callable<U> cacheValueLoader) {
        try {
            Object result = this.cache.get(cacheKey, cacheValueLoader);
            return cacheKey.cast(result);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private <T, U> U executeAndWait(Supplier<T> operation, Converter<T, U> resultConverter) {
        Object result = operation.get();
        return (U)resultConverter.apply(result);
    }
}

