/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.emf.visualizations;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.eclipse.app4mc.emf.visualizations.EObjectRefsConfig;
import org.eclipse.app4mc.emf.visualizations.EObjectRefsGenerator;
import org.eclipse.app4mc.visualization.ui.VisualizationParameters;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.app4mc.visualization.util.svg.PlantUmlDiagram;
import org.eclipse.app4mc.visualization.util.svg.SvgUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=Object references", "description=References Visualization for EObjects"})
public class EObjectRefsVisualization
implements Visualization {
    @PostConstruct
    public void createVisualization(EObject eObject, VisualizationParameters parameters, Composite parent, IEventBroker broker) {
        Context context = new Context(eObject, parameters);
        Composite pane = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(pane);
        Composite buttonArea = new Composite(pane, 0);
        this.addToggleButton(buttonArea, "Horizontal Layout", context.config::setHorizontalLayout, context.config.isHorizontalLayout());
        this.addToggleButton(buttonArea, "Show Labels", context.config::setShowReferenceLabels, context.config.isShowReferenceLabels());
        this.addToggleButton(buttonArea, "Show Derived Refs", context.config::setShowDerivedReferences, context.config.isShowDerivedReferences());
        this.addZoomBox(buttonArea, context);
        RowLayoutFactory.swtDefaults().fill(true).applyTo(buttonArea);
        Browser browser = this.addBrowser(pane, broker, context);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)browser);
        this.updateContent(browser, context);
    }

    private Browser addBrowser(Composite pane, IEventBroker broker, Context context) {
        Browser browser = new Browser(pane, 0);
        if (broker != null) {
            browser.addLocationListener(LocationListener.changingAdapter(c -> {
                c.doit = true;
                Object target = null;
                int idx = c.location.lastIndexOf(35);
                if (idx >= 0) {
                    target = context.diagram.getObjectById(c.location.substring(idx + 1));
                }
                if (target != null) {
                    HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
                    data.put("modelElements", Collections.singletonList(target));
                    broker.send("org/eclipse/app4mc/amalthea/editor/SELECT", data);
                    c.doit = false;
                }
            }));
        }
        context.config.addChangeListener(e -> {
            if (e.getPropertyName().equals("scale")) {
                this.updateSvgScale(browser, (Integer)e.getNewValue());
            }
            if (e.getPropertyName().startsWith("parameter")) {
                this.updateContent(browser, context);
            }
        });
        return browser;
    }

    private void addToggleButton(Composite parent, String text, Consumer<Boolean> f, boolean initialSelected) {
        Button btn = new Button(parent, 0x800002);
        btn.setText(text);
        btn.setSelection(initialSelected);
        btn.addListener(13, e -> f.accept(btn.getSelection()));
    }

    private void addZoomBox(Composite buttonArea, Context context) {
        Composite zoomArea = new Composite(buttonArea, 0);
        RowLayoutFactory.fillDefaults().margins(1, 1).applyTo(zoomArea);
        Composite box = new Composite(zoomArea, 2048);
        Button btnLeft = new Button(box, 0x804004);
        btnLeft.addListener(13, e -> {
            boolean bl = context.config.decrementScale();
        });
        CLabel scaleLabel = new CLabel(box, 0x1800000);
        scaleLabel.setText(String.format("%d %%", context.config.getScale()));
        context.config.addChangeListener(e -> {
            if (e.getPropertyName().equals("scale")) {
                scaleLabel.setText(String.format("%d %%", (int)((Integer)e.getNewValue())));
            }
        });
        Button btnRight = new Button(box, 8519684);
        btnRight.addListener(13, e -> {
            boolean bl = context.config.incrementScale();
        });
        RowLayoutFactory.fillDefaults().fill(true).applyTo(box);
    }

    private void updateSvgScale(Browser browser, int newScale) {
        if (browser != null) {
            browser.execute(SvgUtil.buildUpdateScaleCommand((int)newScale));
        }
    }

    private void updateContent(Browser browser, Context context) {
        new Thread(() -> {
            String result;
            EObjectRefsGenerator.updateDiagram(context.diagram, context.object, context.config);
            try {
                result = context.diagram.renderToSvg();
            }
            catch (IOException e) {
                String result2 = "Error invoking PlantUML: \"" + e.getMessage() + "\". Make sure you have configured the path to the dot executable properly in the PlantUML preferences.";
                Platform.getLog(EObjectRefsVisualization.class).error(result2, (Throwable)e);
                return;
            }
            if (result != null && !browser.isDisposed()) {
                String browserContent = SvgUtil.initiallyApplyScale((String)result, (int)context.config.getScale());
                browser.getDisplay().asyncExec(() -> {
                    if (!browser.isDisposed()) {
                        browser.setText(browserContent);
                    }
                });
            }
        }).start();
    }

    static class Context {
        public final EObject object;
        public final EObjectRefsConfig config;
        public final PlantUmlDiagram diagram = new PlantUmlDiagram();

        public Context(EObject eObject, VisualizationParameters viewParameters) {
            this.object = eObject;
            this.config = new EObjectRefsConfig(viewParameters);
        }
    }
}

