/**
 * *******************************************************************************
 *  Copyright (c) 2015-2020 Robert Bosch GmbH and others.
 * 
 *  This program and the accompanying materials are made
 *  available under the terms of the Eclipse Public License 2.0
 *  which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 *  SPDX-License-Identifier: EPL-2.0
 * 
 *     Generated using Eclipse EMF
 * 
 * *******************************************************************************
 */
package org.eclipse.app4mc.amalthea.model;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.app4mc.amalthea.model.AmaltheaPackage
 * @generated
 */
public interface AmaltheaFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	AmaltheaFactory eINSTANCE = org.eclipse.app4mc.amalthea.model.impl.AmaltheaFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Amalthea</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Amalthea</em>'.
	 * @generated
	 */
	Amalthea createAmalthea();

	/**
	 * Returns a new object of class '<em>Common Elements</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Common Elements</em>'.
	 * @generated
	 */
	CommonElements createCommonElements();

	/**
	 * Returns a new object of class '<em>Tag</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tag</em>'.
	 * @generated
	 */
	Tag createTag();

	/**
	 * Returns a new object of class '<em>Namespace</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Namespace</em>'.
	 * @generated
	 */
	Namespace createNamespace();

	/**
	 * Returns a new object of class '<em>Core Classifier</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Core Classifier</em>'.
	 * @generated
	 */
	CoreClassifier createCoreClassifier();

	/**
	 * Returns a new object of class '<em>Memory Classifier</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Memory Classifier</em>'.
	 * @generated
	 */
	MemoryClassifier createMemoryClassifier();

	/**
	 * Returns a new object of class '<em>Transmission Policy</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Transmission Policy</em>'.
	 * @generated
	 */
	TransmissionPolicy createTransmissionPolicy();

	/**
	 * Returns a new object of class '<em>Time</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time</em>'.
	 * @generated
	 */
	Time createTime();

	/**
	 * Returns a new object of class '<em>Frequency</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Frequency</em>'.
	 * @generated
	 */
	Frequency createFrequency();

	/**
	 * Returns a new object of class '<em>Voltage</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Voltage</em>'.
	 * @generated
	 */
	Voltage createVoltage();

	/**
	 * Returns a new object of class '<em>Data Size</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Size</em>'.
	 * @generated
	 */
	DataSize createDataSize();

	/**
	 * Returns a new object of class '<em>Data Rate</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Rate</em>'.
	 * @generated
	 */
	DataRate createDataRate();

	/**
	 * Returns a new object of class '<em>List Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>List Object</em>'.
	 * @generated
	 */
	ListObject createListObject();

	/**
	 * Returns a new object of class '<em>Map Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Map Object</em>'.
	 * @since 1.2
	 * @generated
	 */
	MapObject createMapObject();

	/**
	 * Returns a new object of class '<em>String Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>String Object</em>'.
	 * @generated
	 */
	StringObject createStringObject();

	/**
	 * Returns a new object of class '<em>Big Integer Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Big Integer Object</em>'.
	 * @generated
	 */
	BigIntegerObject createBigIntegerObject();

	/**
	 * Returns a new object of class '<em>Reference Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Reference Object</em>'.
	 * @generated
	 */
	ReferenceObject createReferenceObject();

	/**
	 * Returns a new object of class '<em>Integer Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Integer Object</em>'.
	 * @generated
	 */
	IntegerObject createIntegerObject();

	/**
	 * Returns a new object of class '<em>Long Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Long Object</em>'.
	 * @generated
	 */
	LongObject createLongObject();

	/**
	 * Returns a new object of class '<em>Float Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Float Object</em>'.
	 * @generated
	 */
	FloatObject createFloatObject();

	/**
	 * Returns a new object of class '<em>Double Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Double Object</em>'.
	 * @generated
	 */
	DoubleObject createDoubleObject();

	/**
	 * Returns a new object of class '<em>Boolean Object</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Boolean Object</em>'.
	 * @generated
	 */
	BooleanObject createBooleanObject();

	/**
	 * Returns a new object of class '<em>Min Avg Max Statistic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Min Avg Max Statistic</em>'.
	 * @generated
	 */
	MinAvgMaxStatistic createMinAvgMaxStatistic();

	/**
	 * Returns a new object of class '<em>Single Value Statistic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Single Value Statistic</em>'.
	 * @generated
	 */
	SingleValueStatistic createSingleValueStatistic();

	/**
	 * Returns a new object of class '<em>Time Constant</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Constant</em>'.
	 * @generated
	 */
	TimeConstant createTimeConstant();

	/**
	 * Returns a new object of class '<em>Time Histogram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Histogram</em>'.
	 * @generated
	 */
	TimeHistogram createTimeHistogram();

	/**
	 * Returns a new object of class '<em>Time Histogram Entry</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Histogram Entry</em>'.
	 * @generated
	 */
	TimeHistogramEntry createTimeHistogramEntry();

	/**
	 * Returns a new object of class '<em>Time Boundaries</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Boundaries</em>'.
	 * @generated
	 */
	TimeBoundaries createTimeBoundaries();

	/**
	 * Returns a new object of class '<em>Time Statistics</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Statistics</em>'.
	 * @generated
	 */
	TimeStatistics createTimeStatistics();

	/**
	 * Returns a new object of class '<em>Time Uniform Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Uniform Distribution</em>'.
	 * @generated
	 */
	TimeUniformDistribution createTimeUniformDistribution();

	/**
	 * Returns a new object of class '<em>Time Gauss Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Gauss Distribution</em>'.
	 * @generated
	 */
	TimeGaussDistribution createTimeGaussDistribution();

	/**
	 * Returns a new object of class '<em>Time Weibull Estimators Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Weibull Estimators Distribution</em>'.
	 * @generated
	 */
	TimeWeibullEstimatorsDistribution createTimeWeibullEstimatorsDistribution();

	/**
	 * Returns a new object of class '<em>Time Beta Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Beta Distribution</em>'.
	 * @generated
	 */
	TimeBetaDistribution createTimeBetaDistribution();

	/**
	 * Returns a new object of class '<em>Discrete Value Constant</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Discrete Value Constant</em>'.
	 * @generated
	 */
	DiscreteValueConstant createDiscreteValueConstant();

	/**
	 * Returns a new object of class '<em>Discrete Value Histogram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Discrete Value Histogram</em>'.
	 * @generated
	 */
	DiscreteValueHistogram createDiscreteValueHistogram();

	/**
	 * Returns a new object of class '<em>Discrete Value Histogram Entry</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Discrete Value Histogram Entry</em>'.
	 * @generated
	 */
	DiscreteValueHistogramEntry createDiscreteValueHistogramEntry();

	/**
	 * Returns a new object of class '<em>Discrete Value Boundaries</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Discrete Value Boundaries</em>'.
	 * @generated
	 */
	DiscreteValueBoundaries createDiscreteValueBoundaries();

	/**
	 * Returns a new object of class '<em>Discrete Value Statistics</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Discrete Value Statistics</em>'.
	 * @generated
	 */
	DiscreteValueStatistics createDiscreteValueStatistics();

	/**
	 * Returns a new object of class '<em>Discrete Value Uniform Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Discrete Value Uniform Distribution</em>'.
	 * @generated
	 */
	DiscreteValueUniformDistribution createDiscreteValueUniformDistribution();

	/**
	 * Returns a new object of class '<em>Discrete Value Gauss Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Discrete Value Gauss Distribution</em>'.
	 * @generated
	 */
	DiscreteValueGaussDistribution createDiscreteValueGaussDistribution();

	/**
	 * Returns a new object of class '<em>Discrete Value Weibull Estimators Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Discrete Value Weibull Estimators Distribution</em>'.
	 * @generated
	 */
	DiscreteValueWeibullEstimatorsDistribution createDiscreteValueWeibullEstimatorsDistribution();

	/**
	 * Returns a new object of class '<em>Discrete Value Beta Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Discrete Value Beta Distribution</em>'.
	 * @generated
	 */
	DiscreteValueBetaDistribution createDiscreteValueBetaDistribution();

	/**
	 * Returns a new object of class '<em>Continuous Value Constant</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Continuous Value Constant</em>'.
	 * @generated
	 */
	ContinuousValueConstant createContinuousValueConstant();

	/**
	 * Returns a new object of class '<em>Continuous Value Histogram</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Continuous Value Histogram</em>'.
	 * @generated
	 */
	ContinuousValueHistogram createContinuousValueHistogram();

	/**
	 * Returns a new object of class '<em>Continuous Value Histogram Entry</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Continuous Value Histogram Entry</em>'.
	 * @generated
	 */
	ContinuousValueHistogramEntry createContinuousValueHistogramEntry();

	/**
	 * Returns a new object of class '<em>Continuous Value Boundaries</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Continuous Value Boundaries</em>'.
	 * @generated
	 */
	ContinuousValueBoundaries createContinuousValueBoundaries();

	/**
	 * Returns a new object of class '<em>Continuous Value Statistics</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Continuous Value Statistics</em>'.
	 * @generated
	 */
	ContinuousValueStatistics createContinuousValueStatistics();

	/**
	 * Returns a new object of class '<em>Continuous Value Uniform Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Continuous Value Uniform Distribution</em>'.
	 * @generated
	 */
	ContinuousValueUniformDistribution createContinuousValueUniformDistribution();

	/**
	 * Returns a new object of class '<em>Continuous Value Gauss Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Continuous Value Gauss Distribution</em>'.
	 * @generated
	 */
	ContinuousValueGaussDistribution createContinuousValueGaussDistribution();

	/**
	 * Returns a new object of class '<em>Continuous Value Weibull Estimators Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Continuous Value Weibull Estimators Distribution</em>'.
	 * @generated
	 */
	ContinuousValueWeibullEstimatorsDistribution createContinuousValueWeibullEstimatorsDistribution();

	/**
	 * Returns a new object of class '<em>Continuous Value Beta Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Continuous Value Beta Distribution</em>'.
	 * @generated
	 */
	ContinuousValueBetaDistribution createContinuousValueBetaDistribution();

	/**
	 * Returns a new object of class '<em>Numeric Mode</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Numeric Mode</em>'.
	 * @generated
	 */
	NumericMode createNumericMode();

	/**
	 * Returns a new object of class '<em>Enum Mode</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Enum Mode</em>'.
	 * @generated
	 */
	EnumMode createEnumMode();

	/**
	 * Returns a new object of class '<em>Mode Literal</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Literal</em>'.
	 * @generated
	 */
	ModeLiteral createModeLiteral();

	/**
	 * Returns a new object of class '<em>Components Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Components Model</em>'.
	 * @generated
	 */
	ComponentsModel createComponentsModel();

	/**
	 * Returns a new object of class '<em>Main Interface</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Main Interface</em>'.
	 * @generated
	 */
	MainInterface createMainInterface();

	/**
	 * Returns a new object of class '<em>Sub Interface</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sub Interface</em>'.
	 * @generated
	 */
	SubInterface createSubInterface();

	/**
	 * Returns a new object of class '<em>Component Port</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Component Port</em>'.
	 * @generated
	 */
	ComponentPort createComponentPort();

	/**
	 * Returns a new object of class '<em>Component Structure</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Component Structure</em>'.
	 * @generated
	 */
	ComponentStructure createComponentStructure();

	/**
	 * Returns a new object of class '<em>Component</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Component</em>'.
	 * @generated
	 */
	Component createComponent();

	/**
	 * Returns a new object of class '<em>Composite</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Composite</em>'.
	 * @generated
	 */
	Composite createComposite();

	/**
	 * Returns a new object of class '<em>System</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>System</em>'.
	 * @generated
	 */
	System createSystem();

	/**
	 * Returns a new object of class '<em>Component Instance</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Component Instance</em>'.
	 * @generated
	 */
	ComponentInstance createComponentInstance();

	/**
	 * Returns a new object of class '<em>Connector</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Connector</em>'.
	 * @generated
	 */
	Connector createConnector();

	/**
	 * Returns a new object of class '<em>Qualified Port</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Qualified Port</em>'.
	 * @generated
	 */
	QualifiedPort createQualifiedPort();

	/**
	 * Returns a new object of class '<em>Config Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Config Model</em>'.
	 * @generated
	 */
	ConfigModel createConfigModel();

	/**
	 * Returns a new object of class '<em>Event Config</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Config</em>'.
	 * @generated
	 */
	EventConfig createEventConfig();

	/**
	 * Returns a new object of class '<em>Constraints Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constraints Model</em>'.
	 * @generated
	 */
	ConstraintsModel createConstraintsModel();

	/**
	 * Returns a new object of class '<em>Runnable Sequencing Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Sequencing Constraint</em>'.
	 * @generated
	 */
	RunnableSequencingConstraint createRunnableSequencingConstraint();

	/**
	 * Returns a new object of class '<em>Runnable Separation Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Separation Constraint</em>'.
	 * @generated
	 */
	RunnableSeparationConstraint createRunnableSeparationConstraint();

	/**
	 * Returns a new object of class '<em>Process Separation Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Separation Constraint</em>'.
	 * @generated
	 */
	ProcessSeparationConstraint createProcessSeparationConstraint();

	/**
	 * Returns a new object of class '<em>Data Separation Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Separation Constraint</em>'.
	 * @generated
	 */
	DataSeparationConstraint createDataSeparationConstraint();

	/**
	 * Returns a new object of class '<em>Runnable Pairing Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Pairing Constraint</em>'.
	 * @generated
	 */
	RunnablePairingConstraint createRunnablePairingConstraint();

	/**
	 * Returns a new object of class '<em>Process Pairing Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Pairing Constraint</em>'.
	 * @generated
	 */
	ProcessPairingConstraint createProcessPairingConstraint();

	/**
	 * Returns a new object of class '<em>Data Pairing Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Pairing Constraint</em>'.
	 * @generated
	 */
	DataPairingConstraint createDataPairingConstraint();

	/**
	 * Returns a new object of class '<em>Target Memory</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Target Memory</em>'.
	 * @generated
	 */
	TargetMemory createTargetMemory();

	/**
	 * Returns a new object of class '<em>Target Core</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Target Core</em>'.
	 * @generated
	 */
	TargetCore createTargetCore();

	/**
	 * Returns a new object of class '<em>Target Scheduler</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Target Scheduler</em>'.
	 * @generated
	 */
	TargetScheduler createTargetScheduler();

	/**
	 * Returns a new object of class '<em>Label Entity Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label Entity Group</em>'.
	 * @generated
	 */
	LabelEntityGroup createLabelEntityGroup();

	/**
	 * Returns a new object of class '<em>Runnable Entity Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Entity Group</em>'.
	 * @generated
	 */
	RunnableEntityGroup createRunnableEntityGroup();

	/**
	 * Returns a new object of class '<em>Process Entity Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Entity Group</em>'.
	 * @generated
	 */
	ProcessEntityGroup createProcessEntityGroup();

	/**
	 * Returns a new object of class '<em>Tag Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Tag Group</em>'.
	 * @generated
	 */
	TagGroup createTagGroup();

	/**
	 * Returns a new object of class '<em>Event Chain</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Chain</em>'.
	 * @generated
	 */
	EventChain createEventChain();

	/**
	 * Returns a new object of class '<em>Sub Event Chain</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sub Event Chain</em>'.
	 * @generated
	 */
	SubEventChain createSubEventChain();

	/**
	 * Returns a new object of class '<em>Event Chain Reference</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Chain Reference</em>'.
	 * @generated
	 */
	EventChainReference createEventChainReference();

	/**
	 * Returns a new object of class '<em>Event Chain Container</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Chain Container</em>'.
	 * @generated
	 */
	EventChainContainer createEventChainContainer();

	/**
	 * Returns a new object of class '<em>Physical Section Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Physical Section Constraint</em>'.
	 * @generated
	 */
	PhysicalSectionConstraint createPhysicalSectionConstraint();

	/**
	 * Returns a new object of class '<em>Event Synchronization Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Synchronization Constraint</em>'.
	 * @generated
	 */
	EventSynchronizationConstraint createEventSynchronizationConstraint();

	/**
	 * Returns a new object of class '<em>Event Chain Synchronization Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Chain Synchronization Constraint</em>'.
	 * @generated
	 */
	EventChainSynchronizationConstraint createEventChainSynchronizationConstraint();

	/**
	 * Returns a new object of class '<em>Delay Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Delay Constraint</em>'.
	 * @generated
	 */
	DelayConstraint createDelayConstraint();

	/**
	 * Returns a new object of class '<em>Event Chain Latency Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Chain Latency Constraint</em>'.
	 * @generated
	 */
	EventChainLatencyConstraint createEventChainLatencyConstraint();

	/**
	 * Returns a new object of class '<em>Repetition Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Repetition Constraint</em>'.
	 * @generated
	 */
	RepetitionConstraint createRepetitionConstraint();

	/**
	 * Returns a new object of class '<em>Data Age Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Age Constraint</em>'.
	 * @generated
	 */
	DataAgeConstraint createDataAgeConstraint();

	/**
	 * Returns a new object of class '<em>Data Age Cycle</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Age Cycle</em>'.
	 * @generated
	 */
	DataAgeCycle createDataAgeCycle();

	/**
	 * Returns a new object of class '<em>Data Age Time</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Age Time</em>'.
	 * @generated
	 */
	DataAgeTime createDataAgeTime();

	/**
	 * Returns a new object of class '<em>Process Requirement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Requirement</em>'.
	 * @generated
	 */
	ProcessRequirement createProcessRequirement();

	/**
	 * Returns a new object of class '<em>Runnable Requirement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Requirement</em>'.
	 * @generated
	 */
	RunnableRequirement createRunnableRequirement();

	/**
	 * Returns a new object of class '<em>Architecture Requirement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Architecture Requirement</em>'.
	 * @generated
	 */
	ArchitectureRequirement createArchitectureRequirement();

	/**
	 * Returns a new object of class '<em>Process Chain Requirement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Chain Requirement</em>'.
	 * @generated
	 */
	ProcessChainRequirement createProcessChainRequirement();

	/**
	 * Returns a new object of class '<em>CPU Percentage Requirement Limit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>CPU Percentage Requirement Limit</em>'.
	 * @generated
	 */
	CPUPercentageRequirementLimit createCPUPercentageRequirementLimit();

	/**
	 * Returns a new object of class '<em>Frequency Requirement Limit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Frequency Requirement Limit</em>'.
	 * @generated
	 */
	FrequencyRequirementLimit createFrequencyRequirementLimit();

	/**
	 * Returns a new object of class '<em>Percentage Requirement Limit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Percentage Requirement Limit</em>'.
	 * @generated
	 */
	PercentageRequirementLimit createPercentageRequirementLimit();

	/**
	 * Returns a new object of class '<em>Count Requirement Limit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Count Requirement Limit</em>'.
	 * @generated
	 */
	CountRequirementLimit createCountRequirementLimit();

	/**
	 * Returns a new object of class '<em>Time Requirement Limit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Time Requirement Limit</em>'.
	 * @generated
	 */
	TimeRequirementLimit createTimeRequirementLimit();

	/**
	 * Returns a new object of class '<em>Data Coherency Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Coherency Group</em>'.
	 * @generated
	 */
	DataCoherencyGroup createDataCoherencyGroup();

	/**
	 * Returns a new object of class '<em>Data Stability Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Stability Group</em>'.
	 * @generated
	 */
	DataStabilityGroup createDataStabilityGroup();

	/**
	 * Returns a new object of class '<em>Process Scope</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Scope</em>'.
	 * @generated
	 */
	ProcessScope createProcessScope();

	/**
	 * Returns a new object of class '<em>Runnable Scope</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Scope</em>'.
	 * @generated
	 */
	RunnableScope createRunnableScope();

	/**
	 * Returns a new object of class '<em>Component Scope</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Component Scope</em>'.
	 * @generated
	 */
	ComponentScope createComponentScope();

	/**
	 * Returns a new object of class '<em>Event Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Model</em>'.
	 * @generated
	 */
	EventModel createEventModel();

	/**
	 * Returns a new object of class '<em>Event Set</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Set</em>'.
	 * @generated
	 */
	EventSet createEventSet();

	/**
	 * Returns a new object of class '<em>Custom Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Custom Event</em>'.
	 * @generated
	 */
	CustomEvent createCustomEvent();

	/**
	 * Returns a new object of class '<em>Stimulus Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Stimulus Event</em>'.
	 * @generated
	 */
	StimulusEvent createStimulusEvent();

	/**
	 * Returns a new object of class '<em>Process Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Event</em>'.
	 * @generated
	 */
	ProcessEvent createProcessEvent();

	/**
	 * Returns a new object of class '<em>Process Chain Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Chain Event</em>'.
	 * @generated
	 */
	ProcessChainEvent createProcessChainEvent();

	/**
	 * Returns a new object of class '<em>Runnable Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Event</em>'.
	 * @generated
	 */
	RunnableEvent createRunnableEvent();

	/**
	 * Returns a new object of class '<em>Label Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label Event</em>'.
	 * @generated
	 */
	LabelEvent createLabelEvent();

	/**
	 * Returns a new object of class '<em>Channel Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Channel Event</em>'.
	 * @generated
	 */
	ChannelEvent createChannelEvent();

	/**
	 * Returns a new object of class '<em>Semaphore Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Semaphore Event</em>'.
	 * @generated
	 */
	SemaphoreEvent createSemaphoreEvent();

	/**
	 * Returns a new object of class '<em>Component Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Component Event</em>'.
	 * @generated
	 */
	ComponentEvent createComponentEvent();

	/**
	 * Returns a new object of class '<em>HW Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>HW Model</em>'.
	 * @generated
	 */
	HWModel createHWModel();

	/**
	 * Returns a new object of class '<em>Hw Structure</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hw Structure</em>'.
	 * @generated
	 */
	HwStructure createHwStructure();

	/**
	 * Returns a new object of class '<em>Frequency Domain</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Frequency Domain</em>'.
	 * @generated
	 */
	FrequencyDomain createFrequencyDomain();

	/**
	 * Returns a new object of class '<em>Power Domain</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Power Domain</em>'.
	 * @generated
	 */
	PowerDomain createPowerDomain();

	/**
	 * Returns a new object of class '<em>Processing Unit</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Processing Unit</em>'.
	 * @generated
	 */
	ProcessingUnit createProcessingUnit();

	/**
	 * Returns a new object of class '<em>Memory</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Memory</em>'.
	 * @generated
	 */
	Memory createMemory();

	/**
	 * Returns a new object of class '<em>Cache</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cache</em>'.
	 * @generated
	 */
	Cache createCache();

	/**
	 * Returns a new object of class '<em>Hw Feature Category</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hw Feature Category</em>'.
	 * @generated
	 */
	HwFeatureCategory createHwFeatureCategory();

	/**
	 * Returns a new object of class '<em>Hw Feature</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hw Feature</em>'.
	 * @generated
	 */
	HwFeature createHwFeature();

	/**
	 * Returns a new object of class '<em>Hw Port</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hw Port</em>'.
	 * @generated
	 */
	HwPort createHwPort();

	/**
	 * Returns a new object of class '<em>Connection Handler</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Connection Handler</em>'.
	 * @generated
	 */
	ConnectionHandler createConnectionHandler();

	/**
	 * Returns a new object of class '<em>Hw Connection</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hw Connection</em>'.
	 * @generated
	 */
	HwConnection createHwConnection();

	/**
	 * Returns a new object of class '<em>Hw Access Element</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hw Access Element</em>'.
	 * @generated
	 */
	HwAccessElement createHwAccessElement();

	/**
	 * Returns a new object of class '<em>Processing Unit Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Processing Unit Definition</em>'.
	 * @generated
	 */
	ProcessingUnitDefinition createProcessingUnitDefinition();

	/**
	 * Returns a new object of class '<em>Connection Handler Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Connection Handler Definition</em>'.
	 * @generated
	 */
	ConnectionHandlerDefinition createConnectionHandlerDefinition();

	/**
	 * Returns a new object of class '<em>Memory Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Memory Definition</em>'.
	 * @generated
	 */
	MemoryDefinition createMemoryDefinition();

	/**
	 * Returns a new object of class '<em>Cache Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Cache Definition</em>'.
	 * @generated
	 */
	CacheDefinition createCacheDefinition();

	/**
	 * Returns a new object of class '<em>Hw Access Path</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Hw Access Path</em>'.
	 * @generated
	 */
	HwAccessPath createHwAccessPath();

	/**
	 * Returns a new object of class '<em>Mapping Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mapping Model</em>'.
	 * @generated
	 */
	MappingModel createMappingModel();

	/**
	 * Returns a new object of class '<em>Scheduler Allocation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Scheduler Allocation</em>'.
	 * @generated
	 */
	SchedulerAllocation createSchedulerAllocation();

	/**
	 * Returns a new object of class '<em>Task Allocation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Task Allocation</em>'.
	 * @generated
	 */
	TaskAllocation createTaskAllocation();

	/**
	 * Returns a new object of class '<em>ISR Allocation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ISR Allocation</em>'.
	 * @generated
	 */
	ISRAllocation createISRAllocation();

	/**
	 * Returns a new object of class '<em>Runnable Allocation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Allocation</em>'.
	 * @generated
	 */
	RunnableAllocation createRunnableAllocation();

	/**
	 * Returns a new object of class '<em>Memory Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Memory Mapping</em>'.
	 * @generated
	 */
	MemoryMapping createMemoryMapping();

	/**
	 * Returns a new object of class '<em>Physical Section Mapping</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Physical Section Mapping</em>'.
	 * @generated
	 */
	PhysicalSectionMapping createPhysicalSectionMapping();

	/**
	 * Returns a new object of class '<em>OS Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>OS Model</em>'.
	 * @generated
	 */
	OSModel createOSModel();

	/**
	 * Returns a new object of class '<em>Os Data Consistency</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Os Data Consistency</em>'.
	 * @generated
	 */
	OsDataConsistency createOsDataConsistency();

	/**
	 * Returns a new object of class '<em>Data Stability</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Stability</em>'.
	 * @generated
	 */
	DataStability createDataStability();

	/**
	 * Returns a new object of class '<em>Non Atomic Data Coherency</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Non Atomic Data Coherency</em>'.
	 * @generated
	 */
	NonAtomicDataCoherency createNonAtomicDataCoherency();

	/**
	 * Returns a new object of class '<em>Semaphore</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Semaphore</em>'.
	 * @generated
	 */
	Semaphore createSemaphore();

	/**
	 * Returns a new object of class '<em>Task Scheduler</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Task Scheduler</em>'.
	 * @generated
	 */
	TaskScheduler createTaskScheduler();

	/**
	 * Returns a new object of class '<em>Scheduler Association</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Scheduler Association</em>'.
	 * @generated
	 */
	SchedulerAssociation createSchedulerAssociation();

	/**
	 * Returns a new object of class '<em>Interrupt Controller</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Interrupt Controller</em>'.
	 * @generated
	 */
	InterruptController createInterruptController();

	/**
	 * Returns a new object of class '<em>Scheduling Parameters</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Scheduling Parameters</em>'.
	 * @generated
	 */
	SchedulingParameters createSchedulingParameters();

	/**
	 * Returns a new object of class '<em>Fixed Priority Preemptive</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Fixed Priority Preemptive</em>'.
	 * @generated
	 */
	FixedPriorityPreemptive createFixedPriorityPreemptive();

	/**
	 * Returns a new object of class '<em>Fixed Priority Preemptive With Budget Enforcement</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Fixed Priority Preemptive With Budget Enforcement</em>'.
	 * @generated
	 */
	FixedPriorityPreemptiveWithBudgetEnforcement createFixedPriorityPreemptiveWithBudgetEnforcement();

	/**
	 * Returns a new object of class '<em>OSEK</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>OSEK</em>'.
	 * @generated
	 */
	OSEK createOSEK();

	/**
	 * Returns a new object of class '<em>Deadline Monotonic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Deadline Monotonic</em>'.
	 * @generated
	 */
	DeadlineMonotonic createDeadlineMonotonic();

	/**
	 * Returns a new object of class '<em>Rate Monotonic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Rate Monotonic</em>'.
	 * @generated
	 */
	RateMonotonic createRateMonotonic();

	/**
	 * Returns a new object of class '<em>Pfair PD2</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pfair PD2</em>'.
	 * @generated
	 */
	PfairPD2 createPfairPD2();

	/**
	 * Returns a new object of class '<em>Partly PFair PD2</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Partly PFair PD2</em>'.
	 * @generated
	 */
	PartlyPFairPD2 createPartlyPFairPD2();

	/**
	 * Returns a new object of class '<em>Early Release Fair PD2</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Early Release Fair PD2</em>'.
	 * @generated
	 */
	EarlyReleaseFairPD2 createEarlyReleaseFairPD2();

	/**
	 * Returns a new object of class '<em>Partly Early Release Fair PD2</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Partly Early Release Fair PD2</em>'.
	 * @generated
	 */
	PartlyEarlyReleaseFairPD2 createPartlyEarlyReleaseFairPD2();

	/**
	 * Returns a new object of class '<em>Least Local Remaining Execution Time First</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Least Local Remaining Execution Time First</em>'.
	 * @generated
	 */
	LeastLocalRemainingExecutionTimeFirst createLeastLocalRemainingExecutionTimeFirst();

	/**
	 * Returns a new object of class '<em>Earliest Deadline First</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Earliest Deadline First</em>'.
	 * @generated
	 */
	EarliestDeadlineFirst createEarliestDeadlineFirst();

	/**
	 * Returns a new object of class '<em>Priority Based Round Robin</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Priority Based Round Robin</em>'.
	 * @generated
	 */
	PriorityBasedRoundRobin createPriorityBasedRoundRobin();

	/**
	 * Returns a new object of class '<em>Deferrable Server</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Deferrable Server</em>'.
	 * @generated
	 */
	DeferrableServer createDeferrableServer();

	/**
	 * Returns a new object of class '<em>Polling Periodic Server</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Polling Periodic Server</em>'.
	 * @generated
	 */
	PollingPeriodicServer createPollingPeriodicServer();

	/**
	 * Returns a new object of class '<em>Sporadic Server</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sporadic Server</em>'.
	 * @generated
	 */
	SporadicServer createSporadicServer();

	/**
	 * Returns a new object of class '<em>Constant Bandwidth Server</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constant Bandwidth Server</em>'.
	 * @generated
	 */
	ConstantBandwidthServer createConstantBandwidthServer();

	/**
	 * Returns a new object of class '<em>Constant Bandwidth Server With CASH</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Constant Bandwidth Server With CASH</em>'.
	 * @generated
	 */
	ConstantBandwidthServerWithCASH createConstantBandwidthServerWithCASH();

	/**
	 * Returns a new object of class '<em>Grouping</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Grouping</em>'.
	 * @generated
	 */
	Grouping createGrouping();

	/**
	 * Returns a new object of class '<em>User Specific Scheduling Algorithm</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>User Specific Scheduling Algorithm</em>'.
	 * @generated
	 */
	UserSpecificSchedulingAlgorithm createUserSpecificSchedulingAlgorithm();

	/**
	 * Returns a new object of class '<em>Priority Based</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Priority Based</em>'.
	 * @generated
	 */
	PriorityBased createPriorityBased();

	/**
	 * Returns a new object of class '<em>Operating System</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Operating System</em>'.
	 * @generated
	 */
	OperatingSystem createOperatingSystem();

	/**
	 * Returns a new object of class '<em>Vendor Operating System</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Vendor Operating System</em>'.
	 * @generated
	 */
	VendorOperatingSystem createVendorOperatingSystem();

	/**
	 * Returns a new object of class '<em>Os Overhead</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Os Overhead</em>'.
	 * @generated
	 */
	OsOverhead createOsOverhead();

	/**
	 * Returns a new object of class '<em>Os API Overhead</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Os API Overhead</em>'.
	 * @generated
	 */
	OsAPIOverhead createOsAPIOverhead();

	/**
	 * Returns a new object of class '<em>Os ISR Overhead</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Os ISR Overhead</em>'.
	 * @generated
	 */
	OsISROverhead createOsISROverhead();

	/**
	 * Returns a new object of class '<em>Property Constraints Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Property Constraints Model</em>'.
	 * @generated
	 */
	PropertyConstraintsModel createPropertyConstraintsModel();

	/**
	 * Returns a new object of class '<em>Process Allocation Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Allocation Constraint</em>'.
	 * @generated
	 */
	ProcessAllocationConstraint createProcessAllocationConstraint();

	/**
	 * Returns a new object of class '<em>Process Prototype Allocation Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Prototype Allocation Constraint</em>'.
	 * @generated
	 */
	ProcessPrototypeAllocationConstraint createProcessPrototypeAllocationConstraint();

	/**
	 * Returns a new object of class '<em>Runnable Allocation Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Allocation Constraint</em>'.
	 * @generated
	 */
	RunnableAllocationConstraint createRunnableAllocationConstraint();

	/**
	 * Returns a new object of class '<em>Abstract Element Mapping Constraint</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Abstract Element Mapping Constraint</em>'.
	 * @generated
	 */
	AbstractElementMappingConstraint createAbstractElementMappingConstraint();

	/**
	 * Returns a new object of class '<em>Core Classification</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Core Classification</em>'.
	 * @generated
	 */
	CoreClassification createCoreClassification();

	/**
	 * Returns a new object of class '<em>Memory Classification</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Memory Classification</em>'.
	 * @generated
	 */
	MemoryClassification createMemoryClassification();

	/**
	 * Returns a new object of class '<em>Stimuli Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Stimuli Model</em>'.
	 * @generated
	 */
	StimuliModel createStimuliModel();

	/**
	 * Returns a new object of class '<em>Mode Value List</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Value List</em>'.
	 * @generated
	 */
	ModeValueList createModeValueList();

	/**
	 * Returns a new object of class '<em>Mode Assignment</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Assignment</em>'.
	 * @generated
	 */
	ModeAssignment createModeAssignment();

	/**
	 * Returns a new object of class '<em>Mode Condition Disjunction</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Condition Disjunction</em>'.
	 * @generated
	 */
	ModeConditionDisjunction createModeConditionDisjunction();

	/**
	 * Returns a new object of class '<em>Mode Value Condition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Value Condition</em>'.
	 * @generated
	 */
	ModeValueCondition createModeValueCondition();

	/**
	 * Returns a new object of class '<em>Mode Label Condition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Label Condition</em>'.
	 * @generated
	 */
	ModeLabelCondition createModeLabelCondition();

	/**
	 * Returns a new object of class '<em>Mode Condition Conjunction</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Condition Conjunction</em>'.
	 * @generated
	 */
	ModeConditionConjunction createModeConditionConjunction();

	/**
	 * Returns a new object of class '<em>Periodic Stimulus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Periodic Stimulus</em>'.
	 * @generated
	 */
	PeriodicStimulus createPeriodicStimulus();

	/**
	 * Returns a new object of class '<em>Relative Periodic Stimulus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Relative Periodic Stimulus</em>'.
	 * @generated
	 */
	RelativePeriodicStimulus createRelativePeriodicStimulus();

	/**
	 * Returns a new object of class '<em>Variable Rate Stimulus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Variable Rate Stimulus</em>'.
	 * @generated
	 */
	VariableRateStimulus createVariableRateStimulus();

	/**
	 * Returns a new object of class '<em>Scenario</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Scenario</em>'.
	 * @generated
	 */
	Scenario createScenario();

	/**
	 * Returns a new object of class '<em>Periodic Synthetic Stimulus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Periodic Synthetic Stimulus</em>'.
	 * @generated
	 */
	PeriodicSyntheticStimulus createPeriodicSyntheticStimulus();

	/**
	 * Returns a new object of class '<em>Custom Stimulus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Custom Stimulus</em>'.
	 * @generated
	 */
	CustomStimulus createCustomStimulus();

	/**
	 * Returns a new object of class '<em>Single Stimulus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Single Stimulus</em>'.
	 * @generated
	 */
	SingleStimulus createSingleStimulus();

	/**
	 * Returns a new object of class '<em>Inter Process Stimulus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Inter Process Stimulus</em>'.
	 * @generated
	 */
	InterProcessStimulus createInterProcessStimulus();

	/**
	 * Returns a new object of class '<em>Periodic Burst Stimulus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Periodic Burst Stimulus</em>'.
	 * @generated
	 */
	PeriodicBurstStimulus createPeriodicBurstStimulus();

	/**
	 * Returns a new object of class '<em>Event Stimulus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Stimulus</em>'.
	 * @generated
	 */
	EventStimulus createEventStimulus();

	/**
	 * Returns a new object of class '<em>Arrival Curve Stimulus</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arrival Curve Stimulus</em>'.
	 * @generated
	 */
	ArrivalCurveStimulus createArrivalCurveStimulus();

	/**
	 * Returns a new object of class '<em>Arrival Curve Entry</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Arrival Curve Entry</em>'.
	 * @generated
	 */
	ArrivalCurveEntry createArrivalCurveEntry();

	/**
	 * Returns a new object of class '<em>Clock Function</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Function</em>'.
	 * @generated
	 */
	ClockFunction createClockFunction();

	/**
	 * Returns a new object of class '<em>Clock Step List</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Step List</em>'.
	 * @generated
	 */
	ClockStepList createClockStepList();

	/**
	 * Returns a new object of class '<em>Clock Step</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clock Step</em>'.
	 * @generated
	 */
	ClockStep createClockStep();

	/**
	 * Returns a new object of class '<em>SW Model</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>SW Model</em>'.
	 * @generated
	 */
	SWModel createSWModel();

	/**
	 * Returns a new object of class '<em>Custom Entity</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Custom Entity</em>'.
	 * @generated
	 */
	CustomEntity createCustomEntity();

	/**
	 * Returns a new object of class '<em>Process Chain</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Chain</em>'.
	 * @generated
	 */
	ProcessChain createProcessChain();

	/**
	 * Returns a new object of class '<em>Activity Graph</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Activity Graph</em>'.
	 * @generated
	 */
	ActivityGraph createActivityGraph();

	/**
	 * Returns a new object of class '<em>Mode Switch</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Switch</em>'.
	 * @generated
	 */
	ModeSwitch createModeSwitch();

	/**
	 * Returns a new object of class '<em>Mode Switch Entry</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Switch Entry</em>'.
	 * @generated
	 */
	ModeSwitchEntry createModeSwitchEntry();

	/**
	 * Returns a new object of class '<em>Mode Switch Default</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Switch Default</em>'.
	 * @generated
	 */
	ModeSwitchDefault createModeSwitchDefault();

	/**
	 * Returns a new object of class '<em>Probability Switch</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Probability Switch</em>'.
	 * @generated
	 */
	ProbabilitySwitch createProbabilitySwitch();

	/**
	 * Returns a new object of class '<em>Probability Switch Entry</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Probability Switch Entry</em>'.
	 * @generated
	 */
	ProbabilitySwitchEntry createProbabilitySwitchEntry();

	/**
	 * Returns a new object of class '<em>While Loop</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>While Loop</em>'.
	 * @generated
	 */
	WhileLoop createWhileLoop();

	/**
	 * Returns a new object of class '<em>Counter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Counter</em>'.
	 * @generated
	 */
	Counter createCounter();

	/**
	 * Returns a new object of class '<em>Wait Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Wait Event</em>'.
	 * @generated
	 */
	WaitEvent createWaitEvent();

	/**
	 * Returns a new object of class '<em>Set Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Set Event</em>'.
	 * @generated
	 */
	SetEvent createSetEvent();

	/**
	 * Returns a new object of class '<em>Clear Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Clear Event</em>'.
	 * @generated
	 */
	ClearEvent createClearEvent();

	/**
	 * Returns a new object of class '<em>Event Mask</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Mask</em>'.
	 * @generated
	 */
	EventMask createEventMask();

	/**
	 * Returns a new object of class '<em>Os Event</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Os Event</em>'.
	 * @generated
	 */
	OsEvent createOsEvent();

	/**
	 * Returns a new object of class '<em>Inter Process Trigger</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Inter Process Trigger</em>'.
	 * @generated
	 */
	InterProcessTrigger createInterProcessTrigger();

	/**
	 * Returns a new object of class '<em>Enforced Migration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Enforced Migration</em>'.
	 * @generated
	 */
	EnforcedMigration createEnforcedMigration();

	/**
	 * Returns a new object of class '<em>Schedule Point</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Schedule Point</em>'.
	 * @generated
	 */
	SchedulePoint createSchedulePoint();

	/**
	 * Returns a new object of class '<em>Terminate Process</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Terminate Process</em>'.
	 * @generated
	 */
	TerminateProcess createTerminateProcess();

	/**
	 * Returns a new object of class '<em>Task</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Task</em>'.
	 * @generated
	 */
	Task createTask();

	/**
	 * Returns a new object of class '<em>ISR</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>ISR</em>'.
	 * @generated
	 */
	ISR createISR();

	/**
	 * Returns a new object of class '<em>Process Prototype</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Process Prototype</em>'.
	 * @generated
	 */
	ProcessPrototype createProcessPrototype();

	/**
	 * Returns a new object of class '<em>Chained Process Prototype</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Chained Process Prototype</em>'.
	 * @generated
	 */
	ChainedProcessPrototype createChainedProcessPrototype();

	/**
	 * Returns a new object of class '<em>Access Precedence Spec</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Access Precedence Spec</em>'.
	 * @generated
	 */
	AccessPrecedenceSpec createAccessPrecedenceSpec();

	/**
	 * Returns a new object of class '<em>Order Precedence Spec</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Order Precedence Spec</em>'.
	 * @generated
	 */
	OrderPrecedenceSpec createOrderPrecedenceSpec();

	/**
	 * Returns a new object of class '<em>Data Dependency</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Dependency</em>'.
	 * @generated
	 */
	DataDependency createDataDependency();

	/**
	 * Returns a new object of class '<em>Runnable Parameter</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Parameter</em>'.
	 * @generated
	 */
	RunnableParameter createRunnableParameter();

	/**
	 * Returns a new object of class '<em>Runnable</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable</em>'.
	 * @generated
	 */
	Runnable createRunnable();

	/**
	 * Returns a new object of class '<em>Label</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label</em>'.
	 * @generated
	 */
	Label createLabel();

	/**
	 * Returns a new object of class '<em>Channel</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Channel</em>'.
	 * @generated
	 */
	Channel createChannel();

	/**
	 * Returns a new object of class '<em>Mode Label</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Label</em>'.
	 * @generated
	 */
	ModeLabel createModeLabel();

	/**
	 * Returns a new object of class '<em>Section</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Section</em>'.
	 * @generated
	 */
	Section createSection();

	/**
	 * Returns a new object of class '<em>Execution Need</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Execution Need</em>'.
	 * @generated
	 */
	ExecutionNeed createExecutionNeed();

	/**
	 * Returns a new object of class '<em>Ticks</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Ticks</em>'.
	 * @generated
	 */
	Ticks createTicks();

	/**
	 * Returns a new object of class '<em>Mode Label Access</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Mode Label Access</em>'.
	 * @generated
	 */
	ModeLabelAccess createModeLabelAccess();

	/**
	 * Returns a new object of class '<em>Label Access</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label Access</em>'.
	 * @generated
	 */
	LabelAccess createLabelAccess();

	/**
	 * Returns a new object of class '<em>Channel Send</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Channel Send</em>'.
	 * @generated
	 */
	ChannelSend createChannelSend();

	/**
	 * Returns a new object of class '<em>Channel Receive</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Channel Receive</em>'.
	 * @generated
	 */
	ChannelReceive createChannelReceive();

	/**
	 * Returns a new object of class '<em>Semaphore Access</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Semaphore Access</em>'.
	 * @generated
	 */
	SemaphoreAccess createSemaphoreAccess();

	/**
	 * Returns a new object of class '<em>Sender Receiver Read</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sender Receiver Read</em>'.
	 * @generated
	 */
	SenderReceiverRead createSenderReceiverRead();

	/**
	 * Returns a new object of class '<em>Sender Receiver Write</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sender Receiver Write</em>'.
	 * @generated
	 */
	SenderReceiverWrite createSenderReceiverWrite();

	/**
	 * Returns a new object of class '<em>Synchronous Server Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Synchronous Server Call</em>'.
	 * @generated
	 */
	SynchronousServerCall createSynchronousServerCall();

	/**
	 * Returns a new object of class '<em>Asynchronous Server Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Asynchronous Server Call</em>'.
	 * @generated
	 */
	AsynchronousServerCall createAsynchronousServerCall();

	/**
	 * Returns a new object of class '<em>Get Result Server Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Get Result Server Call</em>'.
	 * @generated
	 */
	GetResultServerCall createGetResultServerCall();

	/**
	 * Returns a new object of class '<em>Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Group</em>'.
	 * @generated
	 */
	Group createGroup();

	/**
	 * Returns a new object of class '<em>Call Argument</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Call Argument</em>'.
	 * @generated
	 */
	CallArgument createCallArgument();

	/**
	 * Returns a new object of class '<em>Runnable Call</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Runnable Call</em>'.
	 * @generated
	 */
	RunnableCall createRunnableCall();

	/**
	 * Returns a new object of class '<em>Custom Event Trigger</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Custom Event Trigger</em>'.
	 * @generated
	 */
	CustomEventTrigger createCustomEventTrigger();

	/**
	 * Returns a new object of class '<em>Struct</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Struct</em>'.
	 * @generated
	 */
	Struct createStruct();

	/**
	 * Returns a new object of class '<em>Struct Entry</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Struct Entry</em>'.
	 * @generated
	 */
	StructEntry createStructEntry();

	/**
	 * Returns a new object of class '<em>Array</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Array</em>'.
	 * @generated
	 */
	Array createArray();

	/**
	 * Returns a new object of class '<em>Pointer</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Pointer</em>'.
	 * @generated
	 */
	Pointer createPointer();

	/**
	 * Returns a new object of class '<em>Type Ref</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Type Ref</em>'.
	 * @generated
	 */
	TypeRef createTypeRef();

	/**
	 * Returns a new object of class '<em>Alias</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Alias</em>'.
	 * @generated
	 */
	Alias createAlias();

	/**
	 * Returns a new object of class '<em>Data Type Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Data Type Definition</em>'.
	 * @generated
	 */
	DataTypeDefinition createDataTypeDefinition();

	/**
	 * Returns a new object of class '<em>Base Type Definition</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Base Type Definition</em>'.
	 * @generated
	 */
	BaseTypeDefinition createBaseTypeDefinition();

	/**
	 * Returns a new object of class '<em>Periodic Activation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Periodic Activation</em>'.
	 * @generated
	 */
	PeriodicActivation createPeriodicActivation();

	/**
	 * Returns a new object of class '<em>Variable Rate Activation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Variable Rate Activation</em>'.
	 * @generated
	 */
	VariableRateActivation createVariableRateActivation();

	/**
	 * Returns a new object of class '<em>Sporadic Activation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Sporadic Activation</em>'.
	 * @generated
	 */
	SporadicActivation createSporadicActivation();

	/**
	 * Returns a new object of class '<em>Single Activation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Single Activation</em>'.
	 * @generated
	 */
	SingleActivation createSingleActivation();

	/**
	 * Returns a new object of class '<em>Event Activation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Event Activation</em>'.
	 * @generated
	 */
	EventActivation createEventActivation();

	/**
	 * Returns a new object of class '<em>Custom Activation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Custom Activation</em>'.
	 * @generated
	 */
	CustomActivation createCustomActivation();

	/**
	 * Returns a new object of class '<em>Label Access Statistic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Label Access Statistic</em>'.
	 * @generated
	 */
	LabelAccessStatistic createLabelAccessStatistic();

	/**
	 * Returns a new object of class '<em>Run Entity Call Statistic</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Run Entity Call Statistic</em>'.
	 * @generated
	 */
	RunEntityCallStatistic createRunEntityCallStatistic();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	AmaltheaPackage getAmaltheaPackage();

} //AmaltheaFactory
