/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.providers;

import org.apache.commons.lang.StringUtils;
import org.eclipse.app4mc.amalthea.model.presentation.ExtendedAmaltheaEditor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ExtendedAmaltheaLabelProvider
extends DecoratingColumLabelProvider {
    private ExtendedAmaltheaEditor editor = null;

    public ExtendedAmaltheaLabelProvider(ILabelProvider labelProvider, ILabelDecorator labelDecorator) {
        super(labelProvider, labelDecorator);
    }

    public ExtendedAmaltheaLabelProvider(ILabelProvider labelProvider, ILabelDecorator labelDecorator, ExtendedAmaltheaEditor editor) {
        super(labelProvider, labelDecorator);
        this.editor = editor;
    }

    public String getText(Object element) {
        String text = super.getText(element);
        if (StringUtils.isBlank((String)text)) {
            return "???";
        }
        String type = this.getTypeName(element);
        if (StringUtils.isBlank((String)type)) {
            return text;
        }
        String newText = this.stripTypePrefix(text, type);
        if (this.editor != null && this.editor.isShowTypesEnabled()) {
            return String.valueOf(newText) + " [" + type + "]";
        }
        return newText;
    }

    private String getTypeName(Object element) {
        Object target = element;
        if (element instanceof IStructuredSelection) {
            target = ((IStructuredSelection)element).getFirstElement();
        }
        return target instanceof EObject ? ((EObject)target).eClass().getName() : null;
    }

    private String stripTypePrefix(String text, String type) {
        String typeWithBlanks = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)type), (char)' ');
        return StringUtils.removeStart((String)text.trim(), (String)(String.valueOf(typeWithBlanks) + " ")).trim();
    }

    public void dispose() {
        super.dispose();
        this.editor = null;
    }
}

