/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.ide.view;

import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.core.IObservationProvider;
import org.eclipse.amp.axf.ide.AXFWorkbenchPlugin;
import org.eclipse.amp.axf.time.ITimeGranularity;
import org.eclipse.amp.axf.view.SWTAsyncModelListener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;

public class StatusLineView
extends SWTAsyncModelListener
implements IPartListener {
    IViewPart part;
    private static StatusLineView view;

    private StatusLineView() {
        super(null, "Status Line View", 2500L);
        this.setWaitForUpdate(false);
    }

    public void observeStart(IObservationProvider model) {
        this.updateMessage("Started");
    }

    public void observeStop(IObservationProvider model) {
        this.updateMessage("Stopped");
    }

    public void update(IModel model) {
        if (model == AXFWorkbenchPlugin.getDefault().getManager().getActiveModel()) {
            String msg = model.getName();
            msg = String.valueOf(msg) + " " + model.getTimeDescription();
            if (model.getEngine().isPaused()) {
                msg = String.valueOf(msg) + " [PAUSED]";
            } else {
                ITimeGranularity updateGranularity = model.getEngine().getUpdateGranularity();
                if (!updateGranularity.toString().equals("1")) {
                    msg = String.valueOf(msg) + " [" + updateGranularity + "]";
                }
            }
            this.updateMessage(msg);
        }
    }

    private void updateMessage(String msg) {
        if (this.part != null) {
            IViewSite site = (IViewSite)this.part.getSite();
            IActionBars actionBars = site.getActionBars();
            actionBars.getStatusLineManager().setMessage(msg);
            actionBars.updateActionBars();
        }
    }

    public void setPart(IViewPart part) {
        this.part = part;
    }

    public IViewPart getPart() {
        return this.part;
    }

    public void partActivated(IWorkbenchPart part) {
        this.assignPart(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.assignPart(part);
    }

    private void assignPart(IWorkbenchPart part) {
        this.part = part instanceof IViewPart ? (IViewPart)part : null;
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.part) {
            this.part = null;
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public static StatusLineView getDefault() {
        if (view == null) {
            view = new StatusLineView();
        }
        return view;
    }
}

