/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ascape.adapt;

import org.ascape.model.CellOccupant;
import org.ascape.model.HostCell;
import org.eclipse.amp.agf.GraphicsAdapter;
import org.eclipse.amp.agf.IGraphicsAdapter;
import org.eclipse.amp.agf.gef.IFigureProvider;
import org.eclipse.amp.agf.gef.Shapes;
import org.eclipse.amp.escape.ascape.adapt.AscapeGraphicsProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;

public class AscapeGraphicsAdapter
extends GraphicsAdapter {
    private static IGraphicsAdapter singleton;
    private static final IColorProvider[] DEFAULT_COLOR_PROVIDERS;
    private static final ILabelProvider[] DEFAULT_LABEL_PROVIDERS;
    private static final IFigureProvider[] DEFAULT_OCCUPANT_FIGURE_PROVIDERS;
    private static final IFigureProvider[] DEFAULT_FIGURE_PROVIDERS;

    static {
        DEFAULT_COLOR_PROVIDERS = new IColorProvider[]{AscapeGraphicsProvider.getDefault()};
        DEFAULT_LABEL_PROVIDERS = new ILabelProvider[]{AscapeGraphicsProvider.getDefault()};
        DEFAULT_OCCUPANT_FIGURE_PROVIDERS = new IFigureProvider[]{Shapes.OVAL_SHAPE_PROVIDER};
        DEFAULT_FIGURE_PROVIDERS = new IFigureProvider[]{Shapes.RECTANGLE_SHAPE_PROVIDER};
    }

    public IColorProvider[] getColorsForClass(Class type) {
        return DEFAULT_COLOR_PROVIDERS;
    }

    public IFigureProvider[] getFiguresForClass(Class type) {
        if (CellOccupant.class.isAssignableFrom(type)) {
            return DEFAULT_OCCUPANT_FIGURE_PROVIDERS;
        }
        if (HostCell.class == type) {
            return EMPTY_FIGURE_PROVIDERS;
        }
        return DEFAULT_FIGURE_PROVIDERS;
    }

    public ILabelProvider[] getLabelsForClass(Class type) {
        return DEFAULT_LABEL_PROVIDERS;
    }

    public static IGraphicsAdapter getDefault() {
        if (singleton == null) {
            singleton = new AscapeGraphicsAdapter();
        }
        return singleton;
    }
}

