/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.ide;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.java.JClass;
import org.eclipse.emf.java.JCompilationUnit;
import org.eclipse.emf.java.JMember;
import org.eclipse.emf.java.JMethod;
import org.eclipse.emf.java.JVisibility;
import org.eclipse.emf.java.util.JavaPackageResourceFactoryImpl;
import org.eclipse.emf.java.util.JavaResourceFactoryImpl;
import org.metaabm.MetaABMFactory;
import org.metaabm.SAgent;
import org.metaabm.SAttribute;
import org.metaabm.SAttributeType;
import org.metaabm.SNamed;
import org.metaabm.SProjection;
import org.metaabm.act.AGroup;
import org.metaabm.act.ARule;
import org.metaabm.act.ASelect;
import org.metaabm.act.MetaABMActFactory;
import org.metaabm.ide.AgentImporter;

public class JavaAgentImporter
extends AgentImporter {
    public static final Map<String, SAttributeType> supportedTypes = new HashMap<String, SAttributeType>();

    public JavaAgentImporter(SAgent agent, String path) {
        super(agent, path, "Import agent from Java class");
        supportedTypes.put("double", SAttributeType.REAL_LITERAL);
        supportedTypes.put("float", SAttributeType.REAL_LITERAL);
        supportedTypes.put("int", SAttributeType.INTEGER_LITERAL);
        supportedTypes.put("long", SAttributeType.INTEGER_LITERAL);
        supportedTypes.put("short", SAttributeType.INTEGER_LITERAL);
        supportedTypes.put("boolean", SAttributeType.BOOLEAN_LITERAL);
        supportedTypes.put("String", SAttributeType.SYMBOL_LITERAL);
        supportedTypes.put("Double", SAttributeType.REAL_LITERAL);
        supportedTypes.put("Float", SAttributeType.REAL_LITERAL);
        supportedTypes.put("Integer", SAttributeType.INTEGER_LITERAL);
        supportedTypes.put("Long", SAttributeType.INTEGER_LITERAL);
        supportedTypes.put("Short", SAttributeType.INTEGER_LITERAL);
        supportedTypes.put("Boolean", SAttributeType.BOOLEAN_LITERAL);
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.path != null) {
            URI uri = URI.createFileURI((String)this.path);
            JavaResourceFactoryImpl resourceFactory = new JavaResourceFactoryImpl();
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("java", resourceFactory);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("packages", new JavaPackageResourceFactoryImpl());
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(uri, true);
            JCompilationUnit javaSource = (JCompilationUnit)resource.getEObject("/");
            JClass publicClass = (JClass)javaSource.getTypes().get(0);
            monitor.beginTask("Importing from: " + new Path(this.path).lastSegment(), publicClass.getAllMethods().size());
            this.importAsSName((SNamed)this.agent, (JMember)publicClass);
            for (JMethod method : publicClass.getAllMethods()) {
                if (method.getReturnType() != null && method.getVisibility() == JVisibility.PUBLIC_LITERAL) {
                    String propertyName = method.getName();
                    if (propertyName.startsWith("get") || propertyName.startsWith("is")) {
                        if (method.getParameters().size() == 0 && supportedTypes.get(method.getReturnType().getName()) != null) {
                            SAttribute attr = MetaABMFactory.eINSTANCE.createSAttribute();
                            propertyName = propertyName.startsWith("get") ? StringUtils.removeStart((String)propertyName, (String)"get") : StringUtils.removeStart((String)propertyName, (String)"is");
                            propertyName = StringUtils.uncapitalize((String)propertyName);
                            method.setName(propertyName);
                            this.agent.getAttributes().add((Object)attr);
                            this.importAsSName((SNamed)attr, (JMember)method);
                            attr.setSType(supportedTypes.get(method.getReturnType().getName()));
                        }
                    } else if (!propertyName.startsWith("set") && method.getReturnType().getName().equals("void")) {
                        ARule rule = MetaABMActFactory.eINSTANCE.createARule();
                        ((AGroup)this.agent.getRootActivity()).getMembers().add((Object)rule);
                        this.importAsSName((SNamed)rule, (JMember)method);
                        rule.setSelected((ASelect)rule);
                        rule.setAgent(this.agent);
                        if (this.agent.getOwner() != null && this.agent.getOwner().getProjections().size() > 0) {
                            rule.setSpace((SProjection)this.agent.getOwner().getProjections().get(0));
                        }
                    }
                }
                monitor.worked(1);
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    protected void importAsSName(SNamed named, JMember jobject) {
        String description = this.clean(jobject.getComment());
        description = description.replaceAll("\\@*", "");
        description = description.replaceAll("Returns the", "The");
        this.importAsSName(named, jobject.getName(), description);
    }

    private String clean(String comment) {
        if (comment != null) {
            comment = comment.replace("/**", "");
            comment = comment.replace("     */", "");
            comment = comment.replace("     *", "");
            comment = comment.replace("*/", "");
            comment = comment.replace("*", "");
            comment = comment.replace("<ul>", "");
            comment = comment.replace("</ul>", "");
            comment = comment.replace("<p>", "");
            comment = comment.replace("<code>", "");
            comment = comment.replace("&lt;", "<");
            comment = comment.replace("&gt;", ">");
            comment = comment.replace("</code>", "");
            comment = comment.replace("\n ", "");
            comment = comment.replace("\n", "");
            comment = comment.replace("<li> ", "\n  ");
            comment = comment.replace("<li>", "\n  ");
            comment = comment.replace("</li>", "\n");
            comment = comment.replace("<i>", "");
            comment = comment.replace("</i>", "");
            comment = comment.replace("<sup>", "^");
            comment = comment.replace("</sup>", "^");
            comment = comment.replace(".  ", ". ");
            comment = comment.replaceAll("&nbsp;", " ");
            return comment;
        }
        return "";
    }
}

