/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw3d.ConnectionLayerFactory;
import org.eclipse.draw3d.Figure3DFriend;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.geometry.IBoundingBox;
import org.eclipse.draw3d.geometry.IHost3D;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.ParaxialBoundingBox;
import org.eclipse.draw3d.geometry.ParaxialBoundingBoxImpl;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Position3DUtil;
import org.eclipse.draw3d.geometry.Transformable;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometryext.SyncedVector3f;
import org.eclipse.draw3d.geometryext.SynchronizedPosition3DImpl;
import org.eclipse.draw3d.picking.Picker;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.swt.graphics.Font;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Figure3D
extends Figure
implements IFigure3D {
    protected static final Logger log = Logger.getLogger(Figure3D.class.getName());
    private FigureListener childMovedListener = new FigureListener(){

        public void figureMoved(IFigure i_source) {
            Figure3D.this.repaint2DComponents = true;
        }
    };
    protected ConnectionLayer connectionLayer = null;
    protected Figure3DFriend friend;
    protected Figure3DHelper helper;
    protected int m_alpha = 255;
    protected ParaxialBoundingBox m_paraxialBounds;
    final Position3D position3D = this.createPosition3D();
    protected SyncedVector3f preferredSize3D;
    protected boolean repaint2DComponents = true;
    protected boolean updatingBounds = false;

    public Figure3D() {
        this.friend = new Figure3DFriend(this){

            public Font getLocalFont() {
                return Figure3D.this.getLocalFont();
            }

            public boolean is2DContentDirty() {
                return Figure3D.this.repaint2DComponents;
            }
        };
        this.helper = new Figure3DHelper(this.friend);
    }

    public void add(IFigure i_figure, Object i_constraint, int i_index) {
        super.add(i_figure, i_constraint, i_index);
        if (!(i_figure instanceof IFigure3D)) {
            i_figure.addFigureListener(this.childMovedListener);
        }
    }

    @Override
    public void collectRenderFragments(RenderContext i_renderContext) {
    }

    protected Position3D createPosition3D() {
        return new SynchronizedPosition3DImpl(this);
    }

    public IFigure findFigureAt(int i_mx, int i_my, TreeSearch i_search) {
        return this.helper.findFigureAt(i_mx, i_my, i_search);
    }

    public IFigure findMouseEventTargetAt(int i_sx, int i_sy) {
        Picker picker = this.getScene().getPicker();
        ISurface surface = picker.getCurrentSurface();
        return surface.findFigureAt(i_sx, i_sy, null);
    }

    protected void fireFigureMoved() {
        this.position3D.invalidate();
        this.invalidateAncestorParaxialBounds();
        this.invalidateParaxialBoundsTree();
        super.fireFigureMoved();
    }

    @Override
    public int getAlpha() {
        return this.m_alpha;
    }

    @Override
    public IFigure3D getAncestor3D() {
        return Figure3DHelper.getAncestor3D(this.getParent());
    }

    @Override
    public Rectangle getBounds() {
        return super.getBounds();
    }

    @Override
    public IBoundingBox getBounds3D() {
        return this.position3D.getBounds3D();
    }

    @Override
    public List<IFigure> getChildren2D() {
        return this.helper.getChildren2D();
    }

    @Override
    public List<IFigure3D> getChildren3D() {
        return this.helper.getChildren3D();
    }

    @Override
    public ConnectionLayer getConnectionLayer(ConnectionLayerFactory i_clfactory) {
        if (this.connectionLayer == null && i_clfactory != null) {
            this.connectionLayer = i_clfactory.createConnectionLayer(this);
        }
        return this.connectionLayer;
    }

    @Override
    public List<IFigure3D> getDescendants3D() {
        return this.helper.getDescendants3D(true);
    }

    @Override
    public float getDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
        return Float.NaN;
    }

    @Override
    public ParaxialBoundingBox getParaxialBoundingBox(ParaxialBoundingBox o_result) {
        ParaxialBoundingBox paraxialBoundingBox;
        ParaxialBoundingBox result = o_result;
        if (o_result == null) {
            result = new ParaxialBoundingBoxImpl();
        }
        Vector3f location = Draw3DCache.getVector3f();
        Vector3f size = Draw3DCache.getVector3f();
        try {
            if (this.m_paraxialBounds == null) {
                Math3D.getCuboidParaxialBoundingBox((IPosition3D)this.getPosition3D(), (Vector3f)location, (Vector3f)size);
                this.m_paraxialBounds = new ParaxialBoundingBoxImpl();
                this.m_paraxialBounds.setLocation((IVector3f)location);
                this.m_paraxialBounds.setSize((IVector3f)size);
                this.helper.unionWithChildParaxialBounds(this.m_paraxialBounds);
            }
            this.m_paraxialBounds.getLocation(location);
            this.m_paraxialBounds.getSize(size);
            result.setLocation((IVector3f)location);
            result.setSize((IVector3f)size);
            paraxialBoundingBox = result;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{location, size});
        return paraxialBoundingBox;
    }

    public IHost3D getParentHost3D() {
        return this.getAncestor3D();
    }

    public Position3D getPosition3D() {
        return this.position3D;
    }

    @Override
    public IVector3f getPreferredSize3D() {
        if (this.preferredSize3D == null) {
            this.preferredSize3D = new SyncedVector3f();
        }
        return this.preferredSize3D.getVector3f(this.getPreferredSize());
    }

    @Override
    public RenderContext getRenderContext() {
        return this.getAncestor3D().getRenderContext();
    }

    @Override
    public IScene getScene() {
        IFigure p = this.getParent();
        if (p == null) {
            return null;
        }
        return Figure3DHelper.getAncestor3D(p).getScene();
    }

    @Override
    public ISurface getSurface() {
        return null;
    }

    public boolean intersects(Rectangle i_rect) {
        return true;
    }

    public void invalidate() {
        this.position3D.invalidate();
        this.invalidateAncestorParaxialBounds();
        this.invalidateParaxialBoundsTree();
        super.invalidate();
    }

    private void invalidateAncestorParaxialBounds() {
        IFigure parent = this.getParent();
        while (parent != null) {
            if (parent instanceof IFigure3D) {
                ((IFigure3D)parent).invalidateParaxialBounds();
            }
            parent = parent.getParent();
        }
    }

    @Override
    public void invalidateParaxialBounds() {
        this.m_paraxialBounds = null;
    }

    @Override
    public void invalidateParaxialBoundsTree() {
        this.helper.invalidateParaxialBoundsTree();
    }

    public void invalidateTree() {
        this.repaint2DComponents = true;
        super.invalidateTree();
    }

    public void paint(Graphics i_graphics) {
        this.paintBorder(i_graphics);
        this.paintClientArea(i_graphics);
        this.paintFigure(i_graphics);
    }

    protected void paintBorder(Graphics i_graphics) {
        this.helper.paintBorder(i_graphics);
    }

    protected void paintChildren(Graphics i_graphics) {
        this.helper.paintChildren(i_graphics);
        this.repaint2DComponents = false;
    }

    protected void paintFigure(Graphics i_graphics) {
        this.helper.paintFigure(i_graphics);
    }

    public void positionChanged(EnumSet<IPosition3D.PositionHint> i_hint, IVector3f delta) {
        boolean bFigureMoved = false;
        if (i_hint.contains(IPosition3D.PositionHint.SIZE) && (delta.getX() != 0.0f || delta.getY() != 0.0f) && delta.getZ() != 0.0f) {
            this.invalidate();
            bFigureMoved = true;
        }
        if (i_hint.contains(IPosition3D.PositionHint.ROTATION)) {
            bFigureMoved = true;
        }
        if (i_hint.contains(IPosition3D.PositionHint.LOCATION) && (delta.getX() != 0.0f || delta.getY() != 0.0f || delta.getZ() != 0.0f)) {
            bFigureMoved = true;
        }
        if (bFigureMoved) {
            this.fireFigureMoved();
            this.repaint();
        }
    }

    public void remove(IFigure i_figure) {
        super.remove(i_figure);
        if (!(i_figure instanceof IFigure3D)) {
            i_figure.removeFigureListener(this.childMovedListener);
        }
    }

    public void revalidate() {
        super.revalidate();
        this.helper.revalidate();
    }

    @Override
    public void setAlpha(int i_alpha) {
        this.m_alpha = i_alpha;
    }

    @Override
    public void setPreferredSize3D(IVector3f i_preferredSize3D) {
        if (i_preferredSize3D == null) {
            throw new NullPointerException("i_preferredSize3D must not be null");
        }
        if (i_preferredSize3D.getX() < 0.0f || i_preferredSize3D.getY() < 0.0f || i_preferredSize3D.getZ() < 0.0f) {
            throw new IllegalArgumentException("no value of given vector must be less 0, , was " + i_preferredSize3D);
        }
        if (this.preferredSize3D == null) {
            this.preferredSize3D = new SyncedVector3f();
        }
        Dimension size = this.preferredSize3D.setVector3fAsDimension(i_preferredSize3D);
        this.setPreferredSize(size);
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        strb.append(this.getClass().getName()).append(" at (");
        strb.append(this.getPosition3D().getLocation3D()).append(")");
        strb.append(", size (");
        strb.append(this.getPosition3D().getSize3D()).append(")");
        return strb.toString();
    }

    @Override
    public void transformFromParent(Transformable i_transformable) {
        Position3DUtil.transformFromParent((IPosition3D)this.position3D, (Transformable)i_transformable);
    }

    @Override
    public void transformToAbsolute(Transformable io_transformable) {
        Position3DUtil.transformToAbsolute((IPosition3D)this.position3D, (Transformable)io_transformable);
    }

    @Override
    public void transformToParent(Transformable io_transformable) {
        Position3DUtil.transformToParent((IPosition3D)this.position3D, (Transformable)io_transformable);
    }

    @Override
    public void transformToRelative(Transformable io_transformable) {
        Position3DUtil.transformToRelative((IPosition3D)this.position3D, (Transformable)io_transformable);
    }

    public void translateFromParent(Translatable i_t) {
    }

    public void translateToParent(Translatable i_t) {
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public void validate() {
        super.validate();
        this.repaint2DComponents = true;
    }
}

