/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d;

import java.util.Properties;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.Graphics3DType;
import org.eclipse.swt.opengl.GLCanvas;
import org.osgi.framework.Bundle;

public class Graphics3DDescriptor {
    private static final Logger log = Logger.getLogger(Graphics3DDescriptor.class.getName());
    Graphics3DType type;
    String strName;
    String strDescription;
    String strClassname;
    String strRendererID;
    String contributorName;
    Properties parameters = new Properties();

    public String getContributorName() {
        return this.contributorName;
    }

    void setContributorName(String i_contributorName) {
        this.contributorName = i_contributorName;
    }

    public Graphics3DType getType() {
        return this.type;
    }

    void setType(Graphics3DType i_type) {
        this.type = i_type;
    }

    public String getName() {
        return this.strName;
    }

    void setName(String i_strName) {
        this.strName = i_strName;
    }

    public String getDescription() {
        return this.strDescription;
    }

    void setDescription(String i_strDescription) {
        this.strDescription = i_strDescription;
    }

    public String getClassname() {
        return this.strClassname;
    }

    void setClassname(String i_strClassname) {
        this.strClassname = i_strClassname;
    }

    public String getRendererID() {
        return this.strRendererID;
    }

    void setRendererID(String i_strRendererID) {
        this.strRendererID = i_strRendererID;
    }

    public Graphics3D createInstance(GLCanvas i_context) {
        try {
            Bundle bundle = Platform.getBundle((String)this.getContributorName());
            Class clazz = bundle.loadClass(this.strClassname);
            Graphics3D g3d = (Graphics3D)clazz.newInstance();
            g3d.setDescriptor(this);
            if (this.getType() == Graphics3DType.SCREEN) {
                g3d.setGLCanvas(i_context);
            }
            return g3d;
        }
        catch (Exception e) {
            log.warning("Descriptor failed to create renderer: " + this + ", cause: " + e);
            return null;
        }
    }

    public Properties getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append((Object)this.getType()).append(" ");
        result.append(this.getName());
        result.append(" defined in ").append(this.getContributorName());
        result.append(" (").append(this.getDescription()).append(")");
        return result.toString();
    }
}

