/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.issuereport;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public final class PreferenceConstants {
    public static final String P_BUG_REPORT_PREFERENCE_ID = "org.eclipse.fordiac.ide.issuereport";
    public static final String P_BUG_REPORT_MODE = "bugReportingMode";
    public static final String P_BUG_REPORT_DESTINATION = "bugReportingDestination";
    public static final String P_BUG_REPORT_GITLAB_URL = "bugReportingGitLabURL";
    public static final String P_BUG_REPORT_GITLAB_PROJECT_PATH = "bugReportingGitLabProjectPath";
    public static final String P_BUG_REPORT_GITLAB_TOKEN = "bugReportingGitLabToken";
    public static final String P_BUG_REPORT_GITHUB_URL = "bugReportingGitHubURL";
    public static final String P_BUG_REPORT_GITHUB_PROJECT_PATH = "bugReportingGitHubProjectPath";
    public static final String P_BUG_REPORT_GITHUB_TOKEN = "bugReportingGitHubToken";

    private PreferenceConstants() {
    }

    public static ReportMode getReportMode() {
        try {
            return ReportMode.valueOf(PreferenceConstants.getPrefString(P_BUG_REPORT_MODE));
        }
        catch (Exception e) {
            return ReportMode.PROMPT_REPORT;
        }
    }

    public static ReportDestination getReportDestination() {
        try {
            return ReportDestination.valueOf(PreferenceConstants.getPrefString(P_BUG_REPORT_DESTINATION));
        }
        catch (Exception e) {
            return ReportDestination.GITHUB_MANUAL;
        }
    }

    public static String getReportGitLabURL() {
        return PreferenceConstants.getPrefString(P_BUG_REPORT_GITLAB_URL);
    }

    public static String getReportGitLabProjectPath() {
        return PreferenceConstants.getPrefString(P_BUG_REPORT_GITLAB_PROJECT_PATH);
    }

    public static String getReportGitLabToken() {
        return PreferenceConstants.getPrefString(P_BUG_REPORT_GITLAB_TOKEN);
    }

    public static String getReportGitHubURL() {
        return PreferenceConstants.getPrefString(P_BUG_REPORT_GITHUB_URL, "https://api.github.com/");
    }

    public static String getReportGitHubProjectPath() {
        return PreferenceConstants.getPrefString(P_BUG_REPORT_GITHUB_PROJECT_PATH);
    }

    public static String getReportGitHubToken() {
        return PreferenceConstants.getPrefString(P_BUG_REPORT_GITHUB_TOKEN);
    }

    private static String getPrefString(String key) {
        return PreferenceConstants.getPrefString(key, "");
    }

    private static String getPrefString(String key, String defaultValue) {
        return Platform.getPreferencesService().getString(P_BUG_REPORT_PREFERENCE_ID, key, defaultValue, new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE});
    }

    public static enum ReportDestination {
        GITLAB,
        GITHUB,
        GITHUB_MANUAL;

    }

    public static enum ReportMode {
        NO_REPORT,
        PROMPT_REPORT,
        AUTO_REPORT;

    }
}

