/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.marker.resolution;

import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarker;
import org.eclipse.fordiac.ide.systemmanagement.nature.FordiacNature;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.marker.resolution.WorkspaceMarkerResolution;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class MissingLibraryBuilderMarkerResolution
extends WorkspaceMarkerResolution {
    @Override
    protected void runInWorkspace(IMarker[] markers, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)markers.length);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            subMonitor.subTask(marker.getAttribute("message", ""));
            IProject project = marker.getResource().getProject();
            IProjectDescription description = project.getDescription();
            if (FordiacNature.configureLibraryBuilder((IProjectDescription)description)) {
                project.setDescription(description, (IProgressMonitor)subMonitor.split(1));
            } else {
                subMonitor.split(1);
            }
            IProjectNature iProjectNature = project.getNature("org.eclipse.fordiac.ide.systemmanagement.FordiacNature");
            if (iProjectNature instanceof FordiacNature) {
                FordiacNature fordiacNature = (FordiacNature)iProjectNature;
                fordiacNature.validate();
            }
            ++n2;
        }
    }

    public String getLabel() {
        return Messages.MissingLibraryBuilderMarkerResolution_Label;
    }

    public String getDescription() {
        return Messages.MissingLibraryBuilderMarkerResolution_Description;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD");
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return (IMarker[])Stream.of(markers).filter(other -> FordiacNature.class.getName().equals(FordiacErrorMarker.getSource((IMarker)other)) && 3 == FordiacErrorMarker.getCode((IMarker)other)).toArray(IMarker[]::new);
    }
}

