/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.editors;

import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class ApplicationViewerCellModifier
implements ICellModifier {
    public static final String APP_NAME = "APP_NAME";
    public static final String APP_COMMENT = "APP_COMMENT";
    private final CommandStack commandStack;

    public ApplicationViewerCellModifier(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        Application selectedApp = (Application)element;
        return switch (property) {
            case APP_NAME -> selectedApp.getName();
            case APP_COMMENT -> selectedApp.getComment();
            default -> "";
        };
    }

    public void modify(Object element, String property, Object value) {
        Application selectedApp = (Application)((TableItem)element).getData();
        ChangeCommentCommand cmd = switch (property) {
            case APP_NAME -> ChangeNameCommand.forName((INamedElement)selectedApp, (String)value.toString());
            case APP_COMMENT -> new ChangeCommentCommand((INamedElement)selectedApp, value.toString());
            default -> null;
        };
        this.commandStack.execute((Command)cmd);
    }
}

