/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.commands;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class SegmentSetConstraintCommand
extends Command {
    private final Position newPos;
    private Position oldPos;
    private final double newWidth;
    private final double oldWidth;
    private final ChangeBoundsRequest request;
    private final Segment segment;

    public SegmentSetConstraintCommand(Segment segment, Rectangle newBounds, ChangeBoundsRequest request) {
        this.setLabel("Move/Resize");
        this.segment = segment;
        this.request = request;
        this.newPos = CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(newBounds.x, newBounds.y);
        this.newWidth = CoordinateConverter.INSTANCE.screenToIEC61499(newBounds.width);
        this.oldWidth = segment.getWidth();
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        return "move".equals(type) || "move children".equals(type) || "resize".equals(type) || "resize children".equals(type) || "align children".equals(type);
    }

    public void execute() {
        this.oldPos = this.segment.getPosition();
        this.setSegementPosAndWidth(this.newPos, this.newWidth);
    }

    public void redo() {
        this.setSegementPosAndWidth(this.newPos, this.newWidth);
    }

    public void undo() {
        this.setSegementPosAndWidth(this.oldPos, this.oldWidth);
    }

    private void setSegementPosAndWidth(Position pos, double width) {
        this.segment.setPosition(pos);
        this.segment.setWidth(width);
    }
}

