/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.eclipse.fordiac.ide.model.dataexport.AbstractBlockTypeExporter;
import org.eclipse.fordiac.ide.model.dataexport.FBNetworkExporter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.Method;
import org.eclipse.fordiac.ide.model.libraryElement.OtherAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.OtherMethod;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STMethod;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleECAction;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleECState;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.model.libraryElement.TextMethod;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class FbtExporter
extends AbstractBlockTypeExporter {
    public FbtExporter(FBType type) {
        super(type);
    }

    @Override
    protected String getRootTag() {
        return "FBType";
    }

    @Override
    protected void createBlockTypeSpecificXMLEntries() throws XMLStreamException {
        FBType fBType = this.getType();
        if (fBType instanceof CompositeFBType) {
            CompositeFBType cFBT = (CompositeFBType)fBType;
            new FBNetworkExporter(this).createFBNetworkElement(cFBT.getFBNetwork());
        } else {
            FBType fBType2 = this.getType();
            if (fBType2 instanceof BasicFBType) {
                BasicFBType bFBT = (BasicFBType)fBType2;
                this.addBasicFB(bFBT);
            } else {
                FBType fBType3 = this.getType();
                if (fBType3 instanceof SimpleFBType) {
                    SimpleFBType sFBT = (SimpleFBType)fBType3;
                    this.addSimpleFB(sFBT);
                }
            }
        }
    }

    private void addBasicFB(BasicFBType type) throws XMLStreamException {
        this.addStartElement("BasicFB");
        this.addInternalVarList((List<VarDeclaration>)type.getInternalVars(), (List<FB>)type.getInternalFbs(), "InternalVars");
        this.addVarList((List<? extends VarDeclaration>)type.getInternalConstVars(), "InternalConstVars");
        this.addECC(type.getECC());
        for (ICallable callable : type.getCallables()) {
            this.addICallable(callable);
        }
        this.addEndElement();
    }

    private void addOtherAlgorithm(OtherAlgorithm algorithm) throws XMLStreamException {
        this.addStartElement("Other");
        this.getWriter().writeAttribute("Language", algorithm.getLanguage() != null ? algorithm.getLanguage() : "");
        this.writeAlgorithmText(algorithm.getText());
        this.addInlineEndElement();
    }

    private void writeAlgorithmText(String text) throws XMLStreamException {
        if (text != null) {
            this.writeCDataSection(text);
        } else {
            this.getWriter().writeCharacters("");
        }
    }

    private void addSTAlgorithm(STAlgorithm algorithm) throws XMLStreamException {
        this.addStartElement("ST");
        this.writeAlgorithmText(algorithm.getText());
        this.addInlineEndElement();
    }

    private void addECC(ECC ecc) throws XMLStreamException {
        this.addStartElement("ECC");
        if (ecc != null) {
            this.addECStates((List<ECState>)ecc.getECState(), ecc.getStart());
            for (ECTransition transition : ecc.getECTransition()) {
                this.createTransitionEntry(transition);
            }
        }
        this.addEndElement();
    }

    private void createTransitionEntry(ECTransition transition) throws XMLStreamException {
        this.addEmptyStartElement("ECTransition");
        this.getWriter().writeAttribute("Source", transition.getSource().getName());
        this.getWriter().writeAttribute("Destination", transition.getDestination().getName());
        this.getWriter().writeAttribute("Condition", transition.getConditionText());
        if (transition.getComment() != null) {
            this.getWriter().writeAttribute("Comment", transition.getComment());
        }
        this.addXYAttributes(transition);
    }

    private void addECStates(List<ECState> states, ECState startState) throws XMLStreamException {
        this.createECState(startState);
        for (ECState state : states) {
            if (state.equals(startState)) continue;
            this.createECState(state);
        }
    }

    private void createECState(ECState state) throws XMLStreamException {
        this.addStartElement("ECState");
        this.addNameAndCommentAttribute(state);
        this.addXYAttributes(state);
        this.addECActions((List<ECAction>)state.getECAction());
        this.addEndElement();
    }

    private void addECActions(List<ECAction> actions) throws XMLStreamException {
        for (ECAction action : actions) {
            this.addEmptyStartElement("ECAction");
            if (action.getAlgorithm() != null) {
                this.getWriter().writeAttribute("Algorithm", action.getAlgorithm().getName());
            }
            if (action.getOutput() == null) continue;
            this.getWriter().writeAttribute("Output", FbtExporter.getActionOutputEventName(action.getOutput()));
        }
    }

    private static String getActionOutputEventName(Event event) {
        if (event.getBlockFBNetworkElement() instanceof AdapterFB) {
            return event.getBlockFBNetworkElement().getName() + "." + event.getName();
        }
        return event.getName();
    }

    private void addSimpleFB(SimpleFBType type) throws XMLStreamException {
        this.addStartElement("SimpleFB");
        this.addInternalVarList((List<VarDeclaration>)type.getInternalVars(), (List<FB>)type.getInternalFbs(), "InternalVars");
        this.addVarList((List<? extends VarDeclaration>)type.getInternalConstVars(), "InternalConstVars");
        this.addSimpleECStates((List<SimpleECState>)type.getSimpleECStates());
        for (ICallable callable : type.getCallables()) {
            this.addICallable(callable);
        }
        this.addEndElement();
    }

    private void addSimpleECStates(List<SimpleECState> states) throws XMLStreamException {
        for (SimpleECState state : states) {
            this.createSimpleECState(state);
        }
    }

    private void createSimpleECState(SimpleECState state) throws XMLStreamException {
        this.addStartElement("ECState");
        this.addNameAndCommentAttribute(state);
        this.addSimpleECActions((List<SimpleECAction>)state.getSimpleECActions());
        this.addEndElement();
    }

    private void addSimpleECActions(List<SimpleECAction> actions) throws XMLStreamException {
        for (SimpleECAction action : actions) {
            this.addEmptyStartElement("ECAction");
            if (action.getAlgorithm() != null) {
                this.getWriter().writeAttribute("Algorithm", action.getAlgorithm());
            }
            if (action.getOutput() == null) continue;
            this.getWriter().writeAttribute("Output", FbtExporter.getActionOutputEventName(action.getOutput()));
        }
    }

    private void addAlgorithm(Algorithm algorithm) throws XMLStreamException {
        this.addStartElement("Algorithm");
        this.addNameAndCommentAttribute(algorithm);
        if (algorithm instanceof STAlgorithm) {
            STAlgorithm stAlg = (STAlgorithm)algorithm;
            this.addSTAlgorithm(stAlg);
        } else if (algorithm instanceof OtherAlgorithm) {
            OtherAlgorithm oAlg = (OtherAlgorithm)algorithm;
            this.addOtherAlgorithm(oAlg);
        }
        this.addEndElement();
    }

    private void addICallable(ICallable callable) throws XMLStreamException {
        if (callable instanceof Algorithm) {
            Algorithm alg = (Algorithm)callable;
            this.addAlgorithm(alg);
        } else if (callable instanceof Method) {
            Method method = (Method)callable;
            this.addMethod(method);
        }
    }

    private void addMethod(Method method) throws XMLStreamException {
        this.addStartElement("Method");
        this.addNameAttribute(method.getName());
        this.addTypeAttribute(method.getReturnType());
        this.addCommentAttribute(method.getComment());
        if (method instanceof STMethod) {
            STMethod stMethod = (STMethod)method;
            this.addSTMethod(stMethod);
        } else if (method instanceof OtherMethod) {
            OtherMethod oMethod = (OtherMethod)method;
            this.addOtherMethod(oMethod);
        }
        this.addEndElement();
    }

    private void addSTMethod(STMethod method) throws XMLStreamException {
        this.addStartElement("ST");
        this.writeAlgorithmText(method.getText());
        this.addInlineEndElement();
        this.writeTextMethodParameters(method);
    }

    private void addOtherMethod(OtherMethod method) throws XMLStreamException {
        this.addStartElement("Other");
        this.getWriter().writeAttribute("Language", method.getLanguage() != null ? method.getLanguage() : "");
        this.writeAlgorithmText(method.getText());
        this.addInlineEndElement();
        this.writeTextMethodParameters(method);
    }

    private void writeTextMethodParameters(TextMethod method) throws XMLStreamException {
        this.addVarList(method.getInputParameters().stream().map(VarDeclaration.class::cast).toList(), "InputVars");
        this.addVarList(method.getOutputParameters().stream().map(VarDeclaration.class::cast).toList(), "OutputVars");
        this.addVarList(method.getInOutParameters().stream().map(VarDeclaration.class::cast).toList(), "InOutVars");
    }
}

