/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.buildpath.util.BuildpathUtil;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public final class PackageNameHelper {
    public static final String PACKAGE_NAME_DELIMITER = "::";

    public static String getPackageName(LibraryElement libraryElement) {
        String packageName;
        CompilerInfo compilerInfo;
        if (libraryElement != null && (compilerInfo = libraryElement.getCompilerInfo()) != null && (packageName = compilerInfo.getPackageName()) != null) {
            return packageName;
        }
        return "";
    }

    public static String getContainerPackageName(EObject object) {
        EObject eObject = EcoreUtil.getRootContainer((EObject)object);
        if (eObject instanceof LibraryElement) {
            LibraryElement libraryElement = (LibraryElement)eObject;
            return PackageNameHelper.getPackageName(libraryElement);
        }
        return "";
    }

    public static void setPackageName(LibraryElement libraryElement, String packageName) {
        if (libraryElement.getCompilerInfo() == null) {
            libraryElement.setCompilerInfo(LibraryElementFactory.eINSTANCE.createCompilerInfo());
        }
        libraryElement.getCompilerInfo().setPackageName(packageName);
    }

    public static String getFullTypeName(LibraryElement libraryElement) {
        if (libraryElement != null) {
            String packageName = PackageNameHelper.getPackageName(libraryElement);
            if (!packageName.isEmpty()) {
                return packageName + PACKAGE_NAME_DELIMITER + libraryElement.getName();
            }
            return libraryElement.getName();
        }
        return "";
    }

    public static void setFullTypeName(LibraryElement libraryElement, String fullTypeName) {
        int lastIndex = fullTypeName.lastIndexOf(PACKAGE_NAME_DELIMITER);
        if (lastIndex != -1) {
            libraryElement.setName(fullTypeName.substring(lastIndex + PACKAGE_NAME_DELIMITER.length()));
            PackageNameHelper.setPackageName(libraryElement, fullTypeName.substring(0, lastIndex));
        } else {
            libraryElement.setName(fullTypeName);
        }
    }

    public static String extractPlainTypeName(String fullTypeName) {
        int lastIndex = fullTypeName.lastIndexOf(PACKAGE_NAME_DELIMITER);
        if (lastIndex != -1) {
            return fullTypeName.substring(lastIndex + PACKAGE_NAME_DELIMITER.length());
        }
        return fullTypeName;
    }

    public static String extractPackageName(String fullTypeName) {
        int lastIndex = fullTypeName.lastIndexOf(PACKAGE_NAME_DELIMITER);
        if (lastIndex != -1) {
            return fullTypeName.substring(0, lastIndex);
        }
        return "";
    }

    public static String getPackageNameFromURI(URI uri) {
        if (uri.isPlatformResource()) {
            return PackageNameHelper.getPackageNameFromFile(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))));
        }
        return uri.trimSegments(1).segmentsList().stream().collect(Collectors.joining(PACKAGE_NAME_DELIMITER));
    }

    public static String getPackageNameFromFile(IFile file) {
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibrary(file.getProject());
        IPath relativePath = BuildpathUtil.findRelativePath(typeLibrary.getBuildpath(), (IResource)file.getParent()).orElse(file.getParent().getFullPath());
        return Stream.of(relativePath.segments()).collect(Collectors.joining(PACKAGE_NAME_DELIMITER));
    }

    private PackageNameHelper() {
        throw new UnsupportedOperationException();
    }
}

