/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gitlab.wizard;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.gitlab.Messages;
import org.eclipse.fordiac.ide.gitlab.Package;
import org.eclipse.fordiac.ide.gitlab.Project;
import org.eclipse.fordiac.ide.gitlab.management.GitLabDownloader;
import org.eclipse.fordiac.ide.gitlab.treeviewer.GLTreeContentProvider;
import org.eclipse.fordiac.ide.gitlab.treeviewer.LeafNode;
import org.eclipse.fordiac.ide.gitlab.wizard.GitLabImportWizardPage;
import org.eclipse.fordiac.ide.library.LibraryManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class GitLabListedLibsPage
extends WizardPage {
    private ContainerCheckedTreeViewer treeViewer;
    private IProject selectedProject;

    protected GitLabListedLibsPage(String pageName, StructuredSelection selection) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.GitLab_Available_Packages);
        StructuredSelection sel = new StructuredSelection(selection.toList());
        if (!sel.isEmpty()) {
            IFolder folder;
            IContainer iContainer;
            Object object;
            Object object2 = sel.getFirstElement();
            if (object2 instanceof IProject) {
                IProject project;
                this.selectedProject = project = (IProject)object2;
            }
            if ((object = sel.getFirstElement()) instanceof IFolder && (iContainer = (folder = (IFolder)object).getParent()) instanceof IProject) {
                IProject project;
                this.selectedProject = project = (IProject)iContainer;
            }
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        container.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(1, true);
        container.setLayout((Layout)layout);
        this.treeViewer = new ContainerCheckedTreeViewer(container, 2818);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        GitLabListedLibsPage.createColumns((TreeViewer)this.treeViewer);
        this.treeViewer.addCheckStateListener(event -> this.setPageComplete(this.isComplete()));
        this.treeViewer.expandAll();
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    private static void createColumns(TreeViewer viewer) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(viewer, 0);
        viewerColumn.getColumn().setWidth(500);
        viewerColumn.getColumn().setText(Messages.GitLab_Packages_And_Projects);
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Project) {
                    Project project = (Project)element;
                    return project.name();
                }
                if (element instanceof Package) {
                    Package pack = (Package)element;
                    return pack.name();
                }
                if (element instanceof LeafNode) {
                    LeafNode leafNode = (LeafNode)element;
                    return leafNode.getVersion();
                }
                return "";
            }
        });
    }

    private boolean isComplete() {
        return this.treeViewer.getCheckedElements().length != 0;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.treeViewer.setContentProvider((IContentProvider)new GLTreeContentProvider(((GitLabImportWizardPage)this.getPreviousPage()).getDownloadManager().getPackagesAndLeaves()));
        this.treeViewer.setInput(this.getProjectAndPackagesMap());
    }

    public boolean finish() {
        try {
            Object[] objectArray = this.treeViewer.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof LeafNode) {
                    LeafNode leafNode = (LeafNode)o;
                    Path path = ((GitLabImportWizardPage)this.getPreviousPage()).getDownloadManager().packageDownloader(leafNode.getProject(), leafNode.getPackage(), GitLabDownloader.FileFilter.ZIP);
                    if (path != null && this.selectedProject != null) {
                        LibraryManager.INSTANCE.extractLibrary(path, this.selectedProject, true, true);
                    }
                }
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private Map<Project, List<Package>> getProjectAndPackagesMap() {
        if (this.getPreviousPage() instanceof GitLabImportWizardPage && this.getPreviousPage().isPageComplete()) {
            return ((GitLabImportWizardPage)this.getPreviousPage()).getDownloadManager().getProjectsAndPackages();
        }
        return new HashMap<Project, List<Package>>();
    }
}

