/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gitlab.wizard;

import org.eclipse.fordiac.ide.gitlab.Messages;
import org.eclipse.fordiac.ide.gitlab.management.GitLabDownloader;
import org.eclipse.fordiac.ide.gitlab.preferences.PreferenceConstants;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GitLabImportWizardPage
extends WizardPage {
    private Text url;
    private Text token;
    private Composite container;
    private GitLabDownloader downloadManager;

    public GitLabImportWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(Messages.GitLab_Import);
    }

    public GitLabDownloader getDownloadManager() {
        return this.downloadManager;
    }

    public String getUrl() {
        return this.url.getText();
    }

    public String getToken() {
        return this.token.getText();
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        if (complete && this.validateFields()) {
            this.connect();
        }
    }

    private void connect() {
        this.downloadManager = new GitLabDownloader(this.getToken(), this.getUrl());
        this.downloadManager.fetchProjectsAndPackages();
    }

    private boolean validateFields() {
        return !this.url.getText().isEmpty() && !this.token.getText().isEmpty();
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.createLabel(Messages.URL);
        this.url = new Text(this.container, 2052);
        this.url.setText(PreferenceConstants.getURL());
        this.url.setFocus();
        this.createLabel(Messages.Token);
        this.token = new Text(this.container, 0x400804);
        this.token.setText(PreferenceConstants.getToken());
        Button connectionButton = (Button)WidgetFactory.button((int)0).text(Messages.Connect).create((Widget)this.container);
        connectionButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                GitLabImportWizardPage.this.setPageComplete(true);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        GridData gd = new GridData(768);
        this.url.setLayoutData((Object)gd);
        this.token.setLayoutData((Object)gd);
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private Label createLabel(String labelText) {
        Label label = new Label(this.container, 0);
        label.setText(labelText);
        return label;
    }
}

