/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.policies;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.editors.NewInstanceDirectEditManager;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.SelectionRequest;

public abstract class AbstractCreateInstanceDirectEditPolicy
extends DirectEditPolicy {
    protected Command getDirectEditCommand(DirectEditRequest request) {
        Object value = request.getCellEditor().getValue();
        Point refPoint = this.getInsertionPoint(request);
        if (value instanceof TypeEntry) {
            TypeEntry typeEntry = (TypeEntry)value;
            return this.getElementCreateCommand(typeEntry, refPoint);
        }
        return null;
    }

    protected abstract Command getElementCreateCommand(TypeEntry var1, Point var2);

    public void performDirectEdit(SelectionRequest request) {
        NewInstanceDirectEditManager directEditManager = this.createDirectEditManager();
        directEditManager.updateRefPosition(new org.eclipse.swt.graphics.Point(request.getLocation().x, request.getLocation().y));
        if (request.getExtendedData().isEmpty()) {
            directEditManager.show();
        } else {
            Object k = request.getExtendedData().keySet().iterator().next();
            if (k instanceof String) {
                String key = (String)k;
                directEditManager.show(key);
            }
        }
    }

    private NewInstanceDirectEditManager createDirectEditManager() {
        return new NewInstanceDirectEditManager(this.getHost(), this.getTypeLibrary(), false);
    }

    private TypeLibrary getTypeLibrary() {
        return TypeLibraryManager.INSTANCE.getTypeLibraryFromContext(this.getModel());
    }

    private EObject getModel() {
        return (EObject)this.getHost().getModel();
    }

    private Point getInsertionPoint(DirectEditRequest request) {
        Point refPoint = this.getInsertPos((LocationRequest)request);
        SnapToHelper helper = (SnapToHelper)this.getHost().getAdapter(SnapToHelper.class);
        if (helper != null) {
            this.getHost().getFigure().translateToAbsolute((Translatable)refPoint);
            PrecisionPoint preciseLocation = new PrecisionPoint(refPoint);
            PrecisionPoint result = new PrecisionPoint(refPoint);
            helper.snapPoint(null, 192, preciseLocation, result);
            this.getHost().getFigure().translateToRelative((Translatable)result);
            return result;
        }
        return refPoint;
    }

    private double getZoom() {
        RootEditPart root = this.getHost().getRoot();
        if (root instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart scalableEditPart = (ScalableFreeformRootEditPart)root;
            return scalableEditPart.getZoomManager().getZoom();
        }
        return 1.0;
    }

    protected void showCurrentEditValue(DirectEditRequest request) {
    }

    public Point getInsertPos(LocationRequest request) {
        Point location = request.getLocation();
        FigureCanvas figureCanvas = (FigureCanvas)this.getHost().getViewer().getControl();
        Point viewLocation = figureCanvas.getViewport().getViewLocation();
        location.x += viewLocation.x;
        location.y += viewLocation.y;
        return new Point(location.x, location.y).scale(1.0 / this.getZoom());
    }

    protected void eraseDirectEditFeedback(DirectEditRequest request) {
    }
}

