/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.map;

import java.util.Map;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.UnsortedMapIterable;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;

public interface MutableMap<K, V>
extends MutableMapIterable<K, V>,
UnsortedMapIterable<K, V>,
Cloneable {
    public <E> MutableMap<K, V> collectKeysAndValues(Iterable<E> var1, Function<? super E, ? extends K> var2, Function<? super E, ? extends V> var3);

    @Override
    public MutableMap<K, V> newEmpty();

    public MutableMap<K, V> clone();

    @Override
    public MutableMap<K, V> asUnmodifiable();

    @Override
    public MutableMap<K, V> asSynchronized();

    @Override
    public MutableSetMultimap<V, K> flip();

    @Override
    public MutableMap<K, V> select(Predicate2<? super K, ? super V> var1);

    @Override
    public MutableMap<K, V> reject(Predicate2<? super K, ? super V> var1);

    @Override
    public <R> MutableMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> var1);

    @Override
    public <K2, V2> MutableMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> var1);

    @Override
    public MutableMap<K, V> tap(Procedure<? super V> var1);

    @Override
    public MutableBag<V> select(Predicate<? super V> var1);

    @Override
    public <P> MutableBag<V> selectWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public MutableBag<V> reject(Predicate<? super V> var1);

    @Override
    public <P> MutableBag<V> rejectWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public PartitionMutableBag<V> partition(Predicate<? super V> var1);

    @Override
    public <P> PartitionMutableBag<V> partitionWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> var1);

    @Override
    public <R> MutableBag<R> collect(Function<? super V, ? extends R> var1);

    @Override
    public <P, V1> MutableBag<V1> collectWith(Function2<? super V, ? super P, ? extends V1> var1, P var2);

    @Override
    public MutableBooleanBag collectBoolean(BooleanFunction<? super V> var1);

    @Override
    public MutableByteBag collectByte(ByteFunction<? super V> var1);

    @Override
    public MutableCharBag collectChar(CharFunction<? super V> var1);

    @Override
    public MutableDoubleBag collectDouble(DoubleFunction<? super V> var1);

    @Override
    public MutableFloatBag collectFloat(FloatFunction<? super V> var1);

    @Override
    public MutableIntBag collectInt(IntFunction<? super V> var1);

    @Override
    public MutableLongBag collectLong(LongFunction<? super V> var1);

    @Override
    public MutableShortBag collectShort(ShortFunction<? super V> var1);

    @Override
    public <R> MutableBag<R> collectIf(Predicate<? super V> var1, Function<? super V, ? extends R> var2);

    @Override
    public <R> MutableBag<R> flatCollect(Function<? super V, ? extends Iterable<R>> var1);

    @Override
    default public <P, R> MutableBag<R> flatCollectWith(Function2<? super V, ? super P, ? extends Iterable<R>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    @Override
    @Deprecated
    public <S> MutableBag<Pair<V, S>> zip(Iterable<S> var1);

    @Override
    @Deprecated
    public MutableSet<Pair<V, Integer>> zipWithIndex();

    @Override
    public <VV> MutableBagMultimap<VV, V> groupBy(Function<? super V, ? extends VV> var1);

    @Override
    public <VV> MutableBagMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> var1);

    @Override
    default public <V1> MutableMap<V1, V> groupByUniqueKey(Function<? super V, ? extends V1> function) {
        return this.groupByUniqueKey(function, Maps.mutable.withInitialCapacity(this.size()));
    }

    @Override
    default public <KK, VV> MutableMap<KK, VV> aggregateInPlaceBy(Function<? super V, ? extends KK> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        MutableMap map = Maps.mutable.empty();
        this.forEach((? super T each) -> {
            Object key = groupBy.valueOf((Object)each);
            Function0 value = map.getIfAbsentPut(key, zeroValueFactory);
            mutatingAggregator.value((Object)value, (Object)each);
        });
        return map;
    }

    @Override
    default public <KK, VV> MutableMap<KK, VV> aggregateBy(Function<? super V, ? extends KK> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        return this.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator, Maps.mutable.empty());
    }

    @Override
    default public <K1, V1, V2> MutableMap<K1, V2> aggregateBy(Function<? super K, ? extends K1> keyFunction, Function<? super V, ? extends V1> valueFunction, Function0<? extends V2> zeroValueFactory, Function2<? super V2, ? super V1, ? extends V2> nonMutatingAggregator) {
        MutableMap map = Maps.mutable.empty();
        this.forEachKeyValue((key, value) -> map.updateValueWith(keyFunction.valueOf((Object)key), zeroValueFactory, nonMutatingAggregator, valueFunction.valueOf((Object)value)));
        return map;
    }

    @Override
    public MutableMap<V, K> flipUniqueValues();

    @Override
    public MutableMap<K, V> withKeyValue(K var1, V var2);

    @Override
    default public MutableMap<K, V> withMap(Map<? extends K, ? extends V> map) {
        this.putAll(map);
        return this;
    }

    @Override
    default public MutableMap<K, V> withMapIterable(MapIterable<? extends K, ? extends V> mapIterable) {
        this.putAllMapIterable(mapIterable);
        return this;
    }

    @Override
    public MutableMap<K, V> withAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> var1);

    @Override
    public MutableMap<K, V> withAllKeyValueArguments(Pair<? extends K, ? extends V> ... var1);

    @Override
    public MutableMap<K, V> withoutKey(K var1);

    @Override
    public MutableMap<K, V> withoutAllKeys(Iterable<? extends K> var1);
}

